/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.EmbeddedDerby;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.source.MockTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.easymock.annotation.Mock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ConfigDef.Recommender.class})
@PowerMockIgnore(value={"javax.management.*"})
public class JdbcSourceConnectorConfigTest {
    private EmbeddedDerby db;
    private Map<String, String> props;
    private ConfigDef configDef;
    private List<ConfigValue> results;
    @Mock
    private ConfigDef.Recommender mockRecommender;
    private MockTime time = new MockTime();

    @Before
    public void setup() throws Exception {
        this.configDef = null;
        this.results = null;
        this.props = new HashMap<String, String>();
        this.db = new EmbeddedDerby();
        this.db.createTable("some_table", "id", "INT");
        this.db.execute("CREATE SCHEMA PUBLIC_SCHEMA");
        this.db.execute("SET SCHEMA PUBLIC_SCHEMA");
        this.db.createTable("public_table", "id", "INT");
        this.db.execute("CREATE SCHEMA PRIVATE_SCHEMA");
        this.db.execute("SET SCHEMA PRIVATE_SCHEMA");
        this.db.createTable("private_table", "id", "INT");
        this.db.createTable("another_private_table", "id", "INT");
    }

    @After
    public void cleanup() throws Exception {
        this.db.close();
        this.db.dropDatabase();
    }

    @Test
    public void testConfigTableNameRecommenderWithoutSchemaOrTableTypes() throws Exception {
        this.props.put("connection.url", this.db.getUrl());
        this.configDef = JdbcSourceConnectorConfig.baseConfigDef();
        this.results = this.configDef.validate(this.props);
        this.assertWhitelistRecommendations("some_table", "public_table", "private_table", "another_private_table");
        this.assertBlacklistRecommendations("some_table", "public_table", "private_table", "another_private_table");
    }

    @Test
    public void testConfigTableNameRecommenderWitSchemaAndWithoutTableTypes() throws Exception {
        this.props.put("connection.url", this.db.getUrl());
        this.props.put("schema.pattern", "PRIVATE_SCHEMA");
        this.configDef = JdbcSourceConnectorConfig.baseConfigDef();
        this.results = this.configDef.validate(this.props);
        this.assertWhitelistRecommendations("private_table", "another_private_table");
        this.assertBlacklistRecommendations("private_table", "another_private_table");
    }

    @Test
    public void testConfigTableNameRecommenderWithSchemaAndTableTypes() throws Exception {
        this.props.put("connection.url", this.db.getUrl());
        this.props.put("schema.pattern", "PRIVATE_SCHEMA");
        this.props.put("table.types", "VIEW");
        this.configDef = JdbcSourceConnectorConfig.baseConfigDef();
        this.results = this.configDef.validate(this.props);
        this.assertWhitelistRecommendations(new Object[0]);
        this.assertBlacklistRecommendations(new Object[0]);
    }

    @Test
    public void testCachingRecommender() {
        List<String> results1 = Collections.singletonList("xyz");
        List<String> results2 = Collections.singletonList("123");
        EasyMock.expect((Object)this.mockRecommender.validValues((String)EasyMock.anyObject(String.class), (Map)EasyMock.anyObject(Map.class))).andReturn(results1);
        EasyMock.expect((Object)this.mockRecommender.validValues((String)EasyMock.anyObject(String.class), (Map)EasyMock.anyObject(Map.class))).andReturn(results2);
        PowerMock.replayAll((Object[])new Object[0]);
        JdbcSourceConnectorConfig.CachingRecommender recommender = new JdbcSourceConnectorConfig.CachingRecommender(this.mockRecommender, (Time)this.time, 1000L);
        Map<String, String> config1 = Collections.singletonMap("k", "v");
        Assert.assertSame(results1, (Object)recommender.validValues("x", config1));
        this.time.sleep(100L);
        Assert.assertSame(results1, (Object)recommender.validValues("x", config1));
        this.time.sleep(2000L);
        Assert.assertSame(results2, (Object)recommender.validValues("x", config1));
        PowerMock.verifyAll();
    }

    @Test
    public void testDefaultConstructedCachedTableValuesReturnsNull() {
        Map<String, String> config = Collections.singletonMap("k", "v");
        JdbcSourceConnectorConfig.CachedRecommenderValues cached = new JdbcSourceConnectorConfig.CachedRecommenderValues();
        Assert.assertNull((Object)cached.cachedValue(config, 20L));
    }

    @Test
    public void testCachedTableValuesReturnsCachedResultWithinExpiryTime() {
        Map<String, String> config1 = Collections.singletonMap("k", "v");
        Map<String, String> config2 = Collections.singletonMap("k", "v");
        List<String> results = Collections.singletonList("xyz");
        long expiry = 20L;
        JdbcSourceConnectorConfig.CachedRecommenderValues cached = new JdbcSourceConnectorConfig.CachedRecommenderValues(config1, results, expiry);
        Assert.assertSame(results, (Object)cached.cachedValue(config2, expiry - 1L));
    }

    @Test
    public void testCachedTableValuesReturnsNullResultAtOrAfterExpiryTime() {
        Map<String, String> config1 = Collections.singletonMap("k", "v");
        Map<String, String> config2 = Collections.singletonMap("k", "v");
        List<String> results = Collections.singletonList("xyz");
        long expiry = 20L;
        JdbcSourceConnectorConfig.CachedRecommenderValues cached = new JdbcSourceConnectorConfig.CachedRecommenderValues(config1, results, expiry);
        Assert.assertNull((Object)cached.cachedValue(config2, expiry));
        Assert.assertNull((Object)cached.cachedValue(config2, expiry + 1L));
    }

    @Test
    public void testCachedTableValuesReturnsNullResultIfConfigurationChanges() {
        Map<String, String> config1 = Collections.singletonMap("k", "v");
        Map<String, String> config2 = Collections.singletonMap("k", "zed");
        List<String> results = Collections.singletonList("xyz");
        long expiry = 20L;
        JdbcSourceConnectorConfig.CachedRecommenderValues cached = new JdbcSourceConnectorConfig.CachedRecommenderValues(config1, results, expiry);
        Assert.assertNull((Object)cached.cachedValue(config2, expiry - 1L));
        Assert.assertNull((Object)cached.cachedValue(config2, expiry));
        Assert.assertNull((Object)cached.cachedValue(config2, expiry + 1L));
    }

    protected <T> void assertContains(Collection<T> actual, T ... expected) {
        for (T e : expected) {
            Assert.assertTrue((boolean)actual.contains(e));
        }
        Assert.assertEquals((long)expected.length, (long)actual.size());
    }

    protected ConfigValue namedValue(List<ConfigValue> values, String name) {
        for (ConfigValue value : values) {
            if (!value.name().equals(name)) continue;
            return value;
        }
        return null;
    }

    protected <T> void assertRecommendedValues(ConfigValue value, T ... recommendedValues) {
        this.assertContains(value.recommendedValues(), recommendedValues);
    }

    protected <T> void assertWhitelistRecommendations(T ... recommendedValues) {
        this.assertContains(this.namedValue(this.results, "table.whitelist").recommendedValues(), recommendedValues);
    }

    protected <T> void assertBlacklistRecommendations(T ... recommendedValues) {
        this.assertContains(this.namedValue(this.results, "table.blacklist").recommendedValues(), recommendedValues);
    }
}

