/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.util.BytesUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.FileUtils;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDerby {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedDerby.class);
    private static final String NAME_PREFIX = "__test_database_";
    private static final String PROTOCOL = "jdbc:derby:";
    private String name;
    private Connection conn;

    public EmbeddedDerby() {
        this("default");
    }

    public EmbeddedDerby(String name) {
        this.name = name;
        try {
            this.dropDatabase();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new EmbeddedDriver();
        try {
            this.conn = DriverManager.getConnection(this.getUrl());
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't get EmbeddedDerby database connection", e);
        }
    }

    public String getName() {
        return this.name;
    }

    private String getRawName() {
        return NAME_PREFIX + this.name;
    }

    public String getUrl(boolean create) {
        String url = PROTOCOL + this.getRawName();
        if (create) {
            url = url + ";create=true";
        }
        return url;
    }

    public String getUrl() {
        return this.getUrl(true);
    }

    private String getShutdownUrl() {
        return PROTOCOL + this.getRawName() + ";shutdown=true";
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void createTable(String name, String ... fields) throws SQLException {
        if (fields.length == 0) {
            throw new IllegalArgumentException("Must specify at least one column when creating a table");
        }
        if (fields.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify files in pairs of name followed by column spec");
        }
        StringBuilder statement = new StringBuilder();
        statement.append("CREATE TABLE ");
        statement.append(EmbeddedDerby.quoteCaseSensitive(name));
        statement.append(" (");
        for (int i = 0; i < fields.length; i += 2) {
            if (i > 0) {
                statement.append(", ");
            }
            statement.append(EmbeddedDerby.quoteCaseSensitive(fields[i]));
            statement.append(" ");
            statement.append(fields[i + 1]);
        }
        statement.append(")");
        Statement stmt = this.conn.createStatement();
        String statementStr = statement.toString();
        log.debug("Creating table {} in {} with statement {}", new Object[]{name, this.name, statementStr});
        stmt.execute(statementStr);
    }

    public void dropTable(String name) throws SQLException {
        Statement stmt = this.conn.createStatement();
        stmt.execute("DROP TABLE \"" + name + "\"");
    }

    public void close() throws SQLException {
        block2: {
            this.conn.close();
            try {
                DriverManager.getConnection(this.getShutdownUrl());
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 45000 && "08006".equals(se.getSQLState())) break block2;
                throw se;
            }
        }
    }

    public void dropDatabase() throws IOException {
        File dbDir = new File(this.getRawName());
        log.debug("Dropping database {} by removing directory {}", (Object)this.name, (Object)dbDir.getAbsoluteFile());
        FileUtils.deleteDirectory((File)dbDir);
    }

    public void execute(String stmt) throws SQLException {
        this.conn.createStatement().execute(stmt);
    }

    public void insert(String table, Object ... columns) throws IllegalArgumentException, SQLException {
        int i;
        if (columns.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify values to insert as pairs of column name followed by values");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(EmbeddedDerby.quoteCaseSensitive(table));
        builder.append(" (");
        for (i = 0; i < columns.length; i += 2) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(EmbeddedDerby.quoteCaseSensitive(columns[i].toString()));
        }
        builder.append(") VALUES(");
        for (i = 1; i < columns.length; i += 2) {
            if (i > 1) {
                builder.append(", ");
            }
            builder.append(EmbeddedDerby.formatLiteral(columns[i]));
        }
        builder.append(")");
        this.execute(builder.toString());
    }

    public void delete(String table, String where) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(EmbeddedDerby.quoteCaseSensitive(table));
        if (where != null) {
            builder.append(" WHERE ");
            builder.append(where);
        }
        this.execute(builder.toString());
    }

    public void delete(String table, Condition where) throws SQLException {
        this.delete(table, where.toString());
    }

    private static String quoteCaseSensitive(String name) {
        return "\"" + name + "\"";
    }

    private static String formatLiteral(Object value) throws SQLException {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof CharSequence) {
            return "'" + value + "'";
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            byte[] blobData = blob.getBytes(1L, (int)blob.length());
            return "CAST(X'" + BytesUtil.toHex((byte[])blobData) + "' AS BLOB)";
        }
        if (value instanceof byte[]) {
            return "X'" + BytesUtil.toHex((byte[])((byte[])value)) + "'";
        }
        return value.toString();
    }

    public static class Literal {
        String value;

        public Literal(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class EqualsCondition
    extends Condition {
        private Object left;
        private Object right;

        public EqualsCondition(Object left, Object right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return this.left.toString() + " = " + this.right.toString();
        }
    }

    public static class Condition {
    }

    public static class ColumnName
    extends CaseSensitive {
        public ColumnName(String name) {
            super(name);
        }
    }

    public static class TableName
    extends CaseSensitive {
        public TableName(String name) {
            super(name);
        }
    }

    public static class CaseSensitive {
        private String name;

        public CaseSensitive(String name) {
            this.name = name;
        }

        public String toString() {
            return EmbeddedDerby.quoteCaseSensitive(this.name);
        }
    }
}

