/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.metadata;

import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Assert;
import org.junit.Test;

public class FieldsMetadataTest {
    private static final Schema SIMPLE_PRIMITIVE_SCHEMA = Schema.INT64_SCHEMA;
    private static final Schema SIMPLE_STRUCT_SCHEMA = SchemaBuilder.struct().field("name", Schema.STRING_SCHEMA).build();
    private static final Schema SIMPLE_MAP_SCHEMA = SchemaBuilder.map((Schema)SchemaBuilder.INT64_SCHEMA, (Schema)Schema.STRING_SCHEMA);

    @Test(expected=ConnectException.class)
    public void valueSchemaMustBePresentForPkModeRecordValue() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE, Collections.emptyList(), SIMPLE_PRIMITIVE_SCHEMA, null);
    }

    @Test(expected=ConnectException.class)
    public void valueSchemaMustBeStructIfPresent() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.KAFKA, Collections.emptyList(), SIMPLE_PRIMITIVE_SCHEMA, SIMPLE_PRIMITIVE_SCHEMA);
    }

    @Test
    public void missingValueSchemaCanBeOk() {
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("name")), FieldsMetadataTest.extract((JdbcSinkConfig.PrimaryKeyMode)JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY, Collections.emptyList(), (Schema)FieldsMetadataTest.SIMPLE_STRUCT_SCHEMA, null).allFields.keySet());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("__connect_topic", "__connect_partition", "__connect_offset")), FieldsMetadataTest.extract((JdbcSinkConfig.PrimaryKeyMode)JdbcSinkConfig.PrimaryKeyMode.KAFKA, Collections.emptyList(), null, null).allFields.keySet());
    }

    @Test(expected=ConnectException.class)
    public void metadataMayNotBeEmpty() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.NONE, Collections.emptyList(), null, null);
    }

    @Test
    public void kafkaPkMode() {
        FieldsMetadata metadata = FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.KAFKA, Collections.emptyList(), null, SIMPLE_STRUCT_SCHEMA);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("__connect_topic", "__connect_partition", "__connect_offset")), (Object)metadata.keyFieldNames);
        Assert.assertEquals(Collections.singleton("name"), (Object)metadata.nonKeyFieldNames);
        SinkRecordField topicField = (SinkRecordField)metadata.allFields.get("__connect_topic");
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)topicField.schemaType());
        Assert.assertTrue((boolean)topicField.isPrimaryKey());
        Assert.assertFalse((boolean)topicField.isOptional());
        SinkRecordField partitionField = (SinkRecordField)metadata.allFields.get("__connect_partition");
        Assert.assertEquals((Object)Schema.Type.INT32, (Object)partitionField.schemaType());
        Assert.assertTrue((boolean)partitionField.isPrimaryKey());
        Assert.assertFalse((boolean)partitionField.isOptional());
        SinkRecordField offsetField = (SinkRecordField)metadata.allFields.get("__connect_offset");
        Assert.assertEquals((Object)Schema.Type.INT64, (Object)offsetField.schemaType());
        Assert.assertTrue((boolean)offsetField.isPrimaryKey());
        Assert.assertFalse((boolean)offsetField.isOptional());
    }

    @Test
    public void kafkaPkModeCustomNames() {
        List<String> customKeyNames = Arrays.asList("the_topic", "the_partition", "the_offset");
        FieldsMetadata metadata = FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.KAFKA, customKeyNames, null, SIMPLE_STRUCT_SCHEMA);
        Assert.assertEquals(new HashSet<String>(customKeyNames), (Object)metadata.keyFieldNames);
        Assert.assertEquals(Collections.singleton("name"), (Object)metadata.nonKeyFieldNames);
    }

    @Test(expected=ConnectException.class)
    public void kafkaPkModeBadFieldSpec() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.KAFKA, Collections.singletonList("lone"), null, SIMPLE_STRUCT_SCHEMA);
    }

    @Test
    public void recordKeyPkModePrimitiveKey() {
        FieldsMetadata metadata = FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY, Collections.singletonList("the_pk"), SIMPLE_PRIMITIVE_SCHEMA, SIMPLE_STRUCT_SCHEMA);
        Assert.assertEquals(Collections.singleton("the_pk"), (Object)metadata.keyFieldNames);
        Assert.assertEquals(Collections.singleton("name"), (Object)metadata.nonKeyFieldNames);
        Assert.assertEquals((Object)SIMPLE_PRIMITIVE_SCHEMA.type(), (Object)((SinkRecordField)metadata.allFields.get("the_pk")).schemaType());
        Assert.assertTrue((boolean)((SinkRecordField)metadata.allFields.get("the_pk")).isPrimaryKey());
        Assert.assertFalse((boolean)((SinkRecordField)metadata.allFields.get("the_pk")).isOptional());
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((SinkRecordField)metadata.allFields.get("name")).schemaType());
        Assert.assertFalse((boolean)((SinkRecordField)metadata.allFields.get("name")).isPrimaryKey());
        Assert.assertFalse((boolean)((SinkRecordField)metadata.allFields.get("name")).isOptional());
    }

    @Test(expected=ConnectException.class)
    public void recordKeyPkModeWithPrimitiveKeyButMultiplePkFieldsSpecified() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY, Arrays.asList("pk1", "pk2"), SIMPLE_PRIMITIVE_SCHEMA, SIMPLE_STRUCT_SCHEMA);
    }

    @Test(expected=ConnectException.class)
    public void recordKeyPkModeButKeySchemaMissing() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY, Collections.emptyList(), null, SIMPLE_STRUCT_SCHEMA);
    }

    @Test(expected=ConnectException.class)
    public void recordKeyPkModeButKeySchemaAsNonStructCompositeType() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY, Collections.emptyList(), SIMPLE_MAP_SCHEMA, SIMPLE_STRUCT_SCHEMA);
    }

    @Test(expected=ConnectException.class)
    public void recordKeyPkModeWithStructKeyButMissingField() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY, Collections.singletonList("nonexistent"), SIMPLE_STRUCT_SCHEMA, SIMPLE_STRUCT_SCHEMA);
    }

    @Test(expected=ConnectException.class)
    public void recordValuePkModeWithMissingPkField() {
        FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE, Collections.singletonList("nonexistent"), SIMPLE_PRIMITIVE_SCHEMA, SIMPLE_STRUCT_SCHEMA);
    }

    @Test
    public void recordValuePkModeWithValidPkFields() {
        FieldsMetadata metadata = FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE, Collections.singletonList("name"), SIMPLE_PRIMITIVE_SCHEMA, SIMPLE_STRUCT_SCHEMA);
        Assert.assertEquals(Collections.singleton("name"), (Object)metadata.keyFieldNames);
        Assert.assertEquals(Collections.emptySet(), (Object)metadata.nonKeyFieldNames);
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)((SinkRecordField)metadata.allFields.get("name")).schemaType());
        Assert.assertTrue((boolean)((SinkRecordField)metadata.allFields.get("name")).isPrimaryKey());
        Assert.assertFalse((boolean)((SinkRecordField)metadata.allFields.get("name")).isOptional());
    }

    @Test
    public void recordValuePkModeWithPkFieldsAndWhitelistFiltering() {
        Schema valueSchema = SchemaBuilder.struct().field("field1", Schema.INT64_SCHEMA).field("field2", Schema.INT64_SCHEMA).field("field3", Schema.INT64_SCHEMA).field("field4", Schema.INT64_SCHEMA).build();
        FieldsMetadata metadata = FieldsMetadataTest.extract(JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE, Collections.singletonList("field1"), new HashSet<String>(Arrays.asList("field2", "field4")), null, valueSchema);
        Assert.assertEquals(Collections.singleton("field1"), (Object)metadata.keyFieldNames);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("field2", "field4")), (Object)metadata.nonKeyFieldNames);
    }

    private static FieldsMetadata extract(JdbcSinkConfig.PrimaryKeyMode pkMode, List<String> pkFields, Schema keySchema, Schema valueSchema) {
        return FieldsMetadataTest.extract(pkMode, pkFields, Collections.emptySet(), keySchema, valueSchema);
    }

    private static FieldsMetadata extract(JdbcSinkConfig.PrimaryKeyMode pkMode, List<String> pkFields, Set<String> whitelist, Schema keySchema, Schema valueSchema) {
        return FieldsMetadata.extract((String)"table", (JdbcSinkConfig.PrimaryKeyMode)pkMode, pkFields, whitelist, (Schema)keySchema, (Schema)valueSchema);
    }
}

