/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.dialect.SqliteDatabaseDialect;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.SqliteHelper;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.kafka.common.config.AbstractConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqliteHelperTest {
    private final SqliteHelper sqliteHelper = new SqliteHelper(this.getClass().getSimpleName());

    @Before
    public void setUp() throws IOException, SQLException {
        this.sqliteHelper.setUp();
    }

    @After
    public void tearDown() throws IOException, SQLException {
        this.sqliteHelper.tearDown();
    }

    @Test
    public void returnTheDatabaseTableInformation() throws SQLException {
        String createEmployees = "CREATE TABLE employees\n( employee_id INTEGER PRIMARY KEY AUTOINCREMENT,\n  last_name VARCHAR NOT NULL,\n  first_name VARCHAR,\n  hire_date DATE\n);";
        String createProducts = "CREATE TABLE products\n( product_id INTEGER PRIMARY KEY AUTOINCREMENT,\n  product_name VARCHAR NOT NULL,\n  quantity INTEGER NOT NULL DEFAULT 0\n);";
        String createNonPkTable = "CREATE TABLE nonPk (id numeric, response text)";
        this.sqliteHelper.createTable(createEmployees);
        this.sqliteHelper.createTable(createProducts);
        this.sqliteHelper.createTable(createNonPkTable);
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.put("connection.url", this.sqliteHelper.sqliteUri());
        JdbcSinkConfig config = new JdbcSinkConfig(connProps);
        SqliteDatabaseDialect dialect = new SqliteDatabaseDialect((AbstractConfig)config);
        HashMap<String, TableDefinition> tables = new HashMap<String, TableDefinition>();
        for (TableId tableId : dialect.tableIds(this.sqliteHelper.connection)) {
            tables.put(tableId.tableName(), dialect.describeTable(this.sqliteHelper.connection, tableId));
        }
        Assert.assertEquals((long)tables.size(), (long)3L);
        Assert.assertTrue((boolean)tables.containsKey("employees"));
        Assert.assertTrue((boolean)tables.containsKey("products"));
        Assert.assertTrue((boolean)tables.containsKey("nonPk"));
        TableDefinition nonPk = (TableDefinition)tables.get("nonPk");
        Assert.assertEquals((long)2L, (long)nonPk.columnCount());
        ColumnDefinition colDefn = nonPk.definitionForColumn("id");
        Assert.assertTrue((boolean)colDefn.isOptional());
        Assert.assertFalse((boolean)colDefn.isPrimaryKey());
        Assert.assertEquals((long)6L, (long)colDefn.type());
        colDefn = nonPk.definitionForColumn("response");
        Assert.assertTrue((boolean)colDefn.isOptional());
        Assert.assertFalse((boolean)colDefn.isPrimaryKey());
        Assert.assertEquals((long)12L, (long)colDefn.type());
        TableDefinition employees = (TableDefinition)tables.get("employees");
        Assert.assertEquals((long)4L, (long)employees.columnCount());
        Assert.assertNotNull((Object)employees.definitionForColumn("employee_id"));
        Assert.assertFalse((boolean)employees.definitionForColumn("employee_id").isOptional());
        Assert.assertTrue((boolean)employees.definitionForColumn("employee_id").isPrimaryKey());
        Assert.assertEquals((long)4L, (long)employees.definitionForColumn("employee_id").type());
        Assert.assertNotNull((Object)employees.definitionForColumn("last_name"));
        Assert.assertFalse((boolean)employees.definitionForColumn("last_name").isOptional());
        Assert.assertFalse((boolean)employees.definitionForColumn("last_name").isPrimaryKey());
        Assert.assertEquals((long)12L, (long)employees.definitionForColumn("last_name").type());
        Assert.assertNotNull((Object)employees.definitionForColumn("first_name"));
        Assert.assertTrue((boolean)employees.definitionForColumn("first_name").isOptional());
        Assert.assertFalse((boolean)employees.definitionForColumn("first_name").isPrimaryKey());
        Assert.assertEquals((long)12L, (long)employees.definitionForColumn("first_name").type());
        Assert.assertNotNull((Object)employees.definitionForColumn("hire_date"));
        Assert.assertTrue((boolean)employees.definitionForColumn("hire_date").isOptional());
        Assert.assertFalse((boolean)employees.definitionForColumn("hire_date").isPrimaryKey());
        Assert.assertEquals((long)12L, (long)employees.definitionForColumn("hire_date").type());
        TableDefinition products = (TableDefinition)tables.get("products");
        Assert.assertEquals((long)4L, (long)employees.columnCount());
        Assert.assertNotNull((Object)products.definitionForColumn("product_id"));
        Assert.assertFalse((boolean)products.definitionForColumn("product_id").isOptional());
        Assert.assertTrue((boolean)products.definitionForColumn("product_id").isPrimaryKey());
        Assert.assertEquals((long)4L, (long)products.definitionForColumn("product_id").type());
        Assert.assertNotNull((Object)products.definitionForColumn("product_name"));
        Assert.assertFalse((boolean)products.definitionForColumn("product_name").isOptional());
        Assert.assertFalse((boolean)products.definitionForColumn("product_name").isPrimaryKey());
        Assert.assertEquals((long)12L, (long)products.definitionForColumn("product_name").type());
        Assert.assertNotNull((Object)products.definitionForColumn("quantity"));
        Assert.assertFalse((boolean)products.definitionForColumn("quantity").isOptional());
        Assert.assertFalse((boolean)products.definitionForColumn("quantity").isPrimaryKey());
        Assert.assertEquals((long)4L, (long)products.definitionForColumn("quantity").type());
    }
}

