/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class SqliteHelper {
    public final Path dbPath;
    public Connection connection;

    public SqliteHelper(String testId) {
        this.dbPath = Paths.get(testId + ".db", new String[0]);
    }

    public String sqliteUri() {
        return "jdbc:sqlite:" + this.dbPath;
    }

    public void setUp() throws SQLException, IOException {
        Files.deleteIfExists(this.dbPath);
        this.connection = DriverManager.getConnection(this.sqliteUri());
        this.connection.setAutoCommit(false);
    }

    public void tearDown() throws SQLException, IOException {
        this.connection.close();
        Files.deleteIfExists(this.dbPath);
    }

    public void createTable(String createSql) throws SQLException {
        this.execute(createSql);
    }

    public void deleteTable(String table) throws SQLException {
        this.execute("DROP TABLE IF EXISTS " + table);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int select(String query, ResultSetReadCallback callback) throws SQLException {
        int count = 0;
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                callback.read(rs);
                ++count;
            }
        }
        return count;
    }

    public void execute(String sql) throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(sql);
            this.connection.commit();
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ResultSetReadCallback {
        public void read(ResultSet var1) throws SQLException;
    }
}

