/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.PreparedStatementBinder;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PreparedStatementBinderTest {
    private DatabaseDialect dialect;

    @Before
    public void beforeEach() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("connection.url", "jdbc:bogus:something");
        props.put("connection.user", "sa");
        props.put("connection.password", "password");
        JdbcSinkConfig config = new JdbcSinkConfig(props);
        this.dialect = new GenericDatabaseDialect((AbstractConfig)config);
    }

    @Test
    public void bindRecordInsert() throws SQLException, ParseException {
        Schema valueSchema = SchemaBuilder.struct().name("com.example.Person").field("firstName", Schema.STRING_SCHEMA).field("lastName", Schema.STRING_SCHEMA).field("age", Schema.INT32_SCHEMA).field("bool", Schema.BOOLEAN_SCHEMA).field("short", Schema.INT16_SCHEMA).field("byte", Schema.INT8_SCHEMA).field("long", Schema.INT64_SCHEMA).field("float", Schema.FLOAT32_SCHEMA).field("double", Schema.FLOAT64_SCHEMA).field("bytes", Schema.BYTES_SCHEMA).field("decimal", Decimal.schema((int)0)).field("date", org.apache.kafka.connect.data.Date.SCHEMA).field("time", Time.SCHEMA).field("timestamp", org.apache.kafka.connect.data.Timestamp.SCHEMA).field("threshold", Schema.OPTIONAL_FLOAT64_SCHEMA).build();
        Struct valueStruct = new Struct(valueSchema).put("firstName", (Object)"Alex").put("lastName", (Object)"Smith").put("bool", (Object)true).put("short", (Object)1234).put("byte", (Object)-32).put("long", (Object)12425436L).put("float", (Object)Float.valueOf(2356.3f)).put("double", (Object)-2436546.56457).put("bytes", (Object)new byte[]{-32, 124}).put("age", (Object)30).put("decimal", (Object)new BigDecimal("1.5").setScale(0, 6)).put("date", (Object)new java.util.Date(0L)).put("time", (Object)new java.util.Date(1000L)).put("timestamp", (Object)new java.util.Date(100L));
        SchemaPair schemaPair = new SchemaPair(null, valueSchema);
        JdbcSinkConfig.PrimaryKeyMode pkMode = JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE;
        List<String> pkFields = Collections.singletonList("long");
        FieldsMetadata fieldsMetadata = FieldsMetadata.extract((String)"people", (JdbcSinkConfig.PrimaryKeyMode)pkMode, pkFields, Collections.emptySet(), (SchemaPair)schemaPair);
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatementBinder binder = new PreparedStatementBinder(this.dialect, statement, pkMode, schemaPair, fieldsMetadata, JdbcSinkConfig.InsertMode.INSERT);
        binder.bindRecord(new SinkRecord("topic", 0, null, null, valueSchema, (Object)valueStruct, 0L));
        int index = 1;
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setLong(index++, valueStruct.getInt64("long"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setString(index++, valueStruct.getString("firstName"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setString(index++, valueStruct.getString("lastName"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setInt(index++, valueStruct.getInt32("age"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setBoolean(index++, valueStruct.getBoolean("bool"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setShort(index++, valueStruct.getInt16("short"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setByte(index++, valueStruct.getInt8("byte"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setFloat(index++, valueStruct.getFloat32("float").floatValue());
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setDouble(index++, valueStruct.getFloat64("double"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setBytes(index++, valueStruct.getBytes("bytes"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setBigDecimal(index++, (BigDecimal)valueStruct.get("decimal"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setDate(index++, new Date(((java.util.Date)valueStruct.get("date")).getTime()), (Calendar)DateTimeUtils.UTC_CALENDAR.get());
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setTime(index++, new java.sql.Time(((java.util.Date)valueStruct.get("time")).getTime()), (Calendar)DateTimeUtils.UTC_CALENDAR.get());
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setTimestamp(index++, new Timestamp(((java.util.Date)valueStruct.get("timestamp")).getTime()), (Calendar)DateTimeUtils.UTC_CALENDAR.get());
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setObject(index++, null);
    }

    @Test
    public void bindRecordUpsertMode() throws SQLException, ParseException {
        Schema valueSchema = SchemaBuilder.struct().name("com.example.Person").field("firstName", Schema.STRING_SCHEMA).field("long", Schema.INT64_SCHEMA).build();
        Struct valueStruct = new Struct(valueSchema).put("firstName", (Object)"Alex").put("long", (Object)12425436L);
        SchemaPair schemaPair = new SchemaPair(null, valueSchema);
        JdbcSinkConfig.PrimaryKeyMode pkMode = JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE;
        List<String> pkFields = Collections.singletonList("long");
        FieldsMetadata fieldsMetadata = FieldsMetadata.extract((String)"people", (JdbcSinkConfig.PrimaryKeyMode)pkMode, pkFields, Collections.emptySet(), (SchemaPair)schemaPair);
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatementBinder binder = new PreparedStatementBinder(this.dialect, statement, pkMode, schemaPair, fieldsMetadata, JdbcSinkConfig.InsertMode.UPSERT);
        binder.bindRecord(new SinkRecord("topic", 0, null, null, valueSchema, (Object)valueStruct, 0L));
        int index = 1;
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setLong(index++, valueStruct.getInt64("long"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setString(index++, valueStruct.getString("firstName"));
    }

    @Test
    public void bindRecordUpdateMode() throws SQLException, ParseException {
        Schema valueSchema = SchemaBuilder.struct().name("com.example.Person").field("firstName", Schema.STRING_SCHEMA).field("long", Schema.INT64_SCHEMA).build();
        Struct valueStruct = new Struct(valueSchema).put("firstName", (Object)"Alex").put("long", (Object)12425436L);
        SchemaPair schemaPair = new SchemaPair(null, valueSchema);
        JdbcSinkConfig.PrimaryKeyMode pkMode = JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE;
        List<String> pkFields = Collections.singletonList("long");
        FieldsMetadata fieldsMetadata = FieldsMetadata.extract((String)"people", (JdbcSinkConfig.PrimaryKeyMode)pkMode, pkFields, Collections.emptySet(), (SchemaPair)schemaPair);
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatementBinder binder = new PreparedStatementBinder(this.dialect, statement, pkMode, schemaPair, fieldsMetadata, JdbcSinkConfig.InsertMode.UPDATE);
        binder.bindRecord(new SinkRecord("topic", 0, null, null, valueSchema, (Object)valueStruct, 0L));
        int index = 1;
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setString(index++, valueStruct.getString("firstName"));
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setLong(index++, valueStruct.getInt64("long"));
    }
}

