/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.sink.DbStructure;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.junit.Assert;
import org.junit.Test;

public class DbStructureTest {
    DbStructure structure = new DbStructure(null);

    @Test
    public void testNoMissingFields() {
        Assert.assertTrue((boolean)this.missingFields(DbStructureTest.sinkRecords("aaa"), DbStructureTest.columns("aaa", "bbb")).isEmpty());
    }

    @Test
    public void testMissingFieldsWithSameCase() {
        Assert.assertEquals((long)1L, (long)this.missingFields(DbStructureTest.sinkRecords("aaa", "bbb"), DbStructureTest.columns("aaa")).size());
    }

    @Test
    public void testSameNamesDifferentCases() {
        Assert.assertTrue((boolean)this.missingFields(DbStructureTest.sinkRecords("aaa"), DbStructureTest.columns("aAa", "AaA")).isEmpty());
    }

    @Test
    public void testMissingFieldsWithDifferentCase() {
        Assert.assertTrue((boolean)this.missingFields(DbStructureTest.sinkRecords("aaa", "bbb"), DbStructureTest.columns("AaA", "BbB")).isEmpty());
        Assert.assertTrue((boolean)this.missingFields(DbStructureTest.sinkRecords("AaA", "bBb"), DbStructureTest.columns("aaa", "bbb")).isEmpty());
        Assert.assertTrue((boolean)this.missingFields(DbStructureTest.sinkRecords("AaA", "bBb"), DbStructureTest.columns("aAa", "BbB")).isEmpty());
    }

    private Set<SinkRecordField> missingFields(Collection<SinkRecordField> fields, Set<String> dbColumnNames) {
        return this.structure.missingFields(fields, dbColumnNames);
    }

    static Set<String> columns(String ... names) {
        return new HashSet<String>(Arrays.asList(names));
    }

    static List<SinkRecordField> sinkRecords(String ... names) {
        ArrayList<SinkRecordField> fields = new ArrayList<SinkRecordField>();
        for (String n : names) {
            fields.add(DbStructureTest.field(n));
        }
        return fields;
    }

    static SinkRecordField field(String name) {
        return new SinkRecordField(Schema.STRING_SCHEMA, name, false);
    }
}

