/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialects;
import io.confluent.connect.jdbc.sink.BufferedRecords;
import io.confluent.connect.jdbc.sink.DbStructure;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.SqliteHelper;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.util.TableId;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BufferedRecordsTest {
    private final SqliteHelper sqliteHelper = new SqliteHelper(this.getClass().getSimpleName());

    @Before
    public void setUp() throws IOException, SQLException {
        this.sqliteHelper.setUp();
    }

    @After
    public void tearDown() throws IOException, SQLException {
        this.sqliteHelper.tearDown();
    }

    @Test
    public void correctBatching() throws SQLException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("connection.url", this.sqliteHelper.sqliteUri());
        props.put("auto.create", true);
        props.put("auto.evolve", true);
        props.put("batch.size", 1000);
        JdbcSinkConfig config = new JdbcSinkConfig(props);
        String url = this.sqliteHelper.sqliteUri();
        DatabaseDialect dbDialect = DatabaseDialects.findBestFor((String)url, (AbstractConfig)config);
        DbStructure dbStructure = new DbStructure(dbDialect);
        TableId tableId = new TableId(null, null, "dummy");
        BufferedRecords buffer = new BufferedRecords(config, tableId, dbDialect, dbStructure, this.sqliteHelper.connection);
        Schema schemaA = SchemaBuilder.struct().field("name", Schema.STRING_SCHEMA).build();
        Struct valueA = new Struct(schemaA).put("name", (Object)"cuba");
        SinkRecord recordA = new SinkRecord("dummy", 0, null, null, schemaA, (Object)valueA, 0L);
        Schema schemaB = SchemaBuilder.struct().field("name", Schema.STRING_SCHEMA).field("age", Schema.OPTIONAL_INT32_SCHEMA).build();
        Struct valueB = new Struct(schemaB).put("name", (Object)"cuba").put("age", (Object)4);
        SinkRecord recordB = new SinkRecord("dummy", 1, null, null, schemaB, (Object)valueB, 1L);
        Assert.assertEquals(Collections.emptyList(), (Object)buffer.add(recordA));
        Assert.assertEquals(Collections.emptyList(), (Object)buffer.add(recordA));
        Assert.assertEquals(Collections.emptyList(), (Object)buffer.add(recordA));
        Assert.assertEquals(Arrays.asList(recordA, recordA, recordA), (Object)buffer.add(recordB));
        Assert.assertEquals(Collections.singletonList(recordB), (Object)buffer.add(recordA));
        Assert.assertEquals(Collections.singletonList(recordA), (Object)buffer.flush());
    }

    @Test
    public void testFlushSuccessNoInfo() throws SQLException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("connection.url", "");
        props.put("auto.create", true);
        props.put("auto.evolve", true);
        props.put("batch.size", 1000);
        JdbcSinkConfig config = new JdbcSinkConfig(props);
        String url = this.sqliteHelper.sqliteUri();
        DatabaseDialect dbDialect = DatabaseDialects.findBestFor((String)url, (AbstractConfig)config);
        int[] batchResponse = new int[]{-2, -2};
        DbStructure dbStructureMock = (DbStructure)Mockito.mock(DbStructure.class);
        Mockito.when((Object)dbStructureMock.createOrAmendIfNecessary((JdbcSinkConfig)Matchers.any(JdbcSinkConfig.class), (Connection)Matchers.any(Connection.class), (TableId)Matchers.any(TableId.class), (FieldsMetadata)Matchers.any(FieldsMetadata.class))).thenReturn((Object)true);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatementMock.executeBatch()).thenReturn((Object)batchResponse);
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionMock.prepareStatement(Matchers.anyString())).thenReturn((Object)preparedStatementMock);
        TableId tableId = new TableId(null, null, "dummy");
        BufferedRecords buffer = new BufferedRecords(config, tableId, dbDialect, dbStructureMock, connectionMock);
        Schema schemaA = SchemaBuilder.struct().field("name", Schema.STRING_SCHEMA).build();
        Struct valueA = new Struct(schemaA).put("name", (Object)"cuba");
        SinkRecord recordA = new SinkRecord("dummy", 0, null, null, schemaA, (Object)valueA, 0L);
        buffer.add(recordA);
        Schema schemaB = SchemaBuilder.struct().field("name", Schema.STRING_SCHEMA).build();
        Struct valueB = new Struct(schemaA).put("name", (Object)"cubb");
        SinkRecord recordB = new SinkRecord("dummy", 0, null, null, schemaB, (Object)valueB, 0L);
        buffer.add(recordB);
        buffer.flush();
    }

    @Test
    public void testInsertModeUpdate() throws SQLException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("connection.url", "");
        props.put("auto.create", true);
        props.put("auto.evolve", true);
        props.put("batch.size", 1000);
        props.put("insert.mode", "update");
        JdbcSinkConfig config = new JdbcSinkConfig(props);
        String url = this.sqliteHelper.sqliteUri();
        DatabaseDialect dbDialect = DatabaseDialects.findBestFor((String)url, (AbstractConfig)config);
        DbStructure dbStructureMock = (DbStructure)Mockito.mock(DbStructure.class);
        Mockito.when((Object)dbStructureMock.createOrAmendIfNecessary((JdbcSinkConfig)Matchers.any(JdbcSinkConfig.class), (Connection)Matchers.any(Connection.class), (TableId)Matchers.any(TableId.class), (FieldsMetadata)Matchers.any(FieldsMetadata.class))).thenReturn((Object)true);
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        TableId tableId = new TableId(null, null, "dummy");
        BufferedRecords buffer = new BufferedRecords(config, tableId, dbDialect, dbStructureMock, connectionMock);
        Schema schemaA = SchemaBuilder.struct().field("name", Schema.STRING_SCHEMA).build();
        Struct valueA = new Struct(schemaA).put("name", (Object)"cuba");
        SinkRecord recordA = new SinkRecord("dummy", 0, null, null, schemaA, (Object)valueA, 0L);
        buffer.add(recordA);
        ((Connection)Mockito.verify((Object)connectionMock, (VerificationMode)Mockito.times((int)1))).prepareStatement((String)Matchers.eq((Object)"UPDATE `dummy` SET `name` = ?"));
    }
}

