/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.VerticaDatabaseDialect;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class VerticaDatabaseDialectTest
extends BaseDialectTest<VerticaDatabaseDialect> {
    @Override
    protected VerticaDatabaseDialect createDialect() {
        return new VerticaDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:vertica://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "INT");
        this.assertPrimitiveMapping(Schema.Type.INT16, "INT");
        this.assertPrimitiveMapping(Schema.Type.INT32, "INT");
        this.assertPrimitiveMapping(Schema.Type.INT64, "INT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "FLOAT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "FLOAT");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "BOOLEAN");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "VARBINARY(1024)");
        this.assertPrimitiveMapping(Schema.Type.STRING, "VARCHAR(1024)");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "DECIMAL(18,0)");
        this.assertDecimalMapping(3, "DECIMAL(18,3)");
        this.assertDecimalMapping(4, "DECIMAL(18,4)");
        this.assertDecimalMapping(5, "DECIMAL(18,5)");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("INT", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("INT", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("INT", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("INT", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("FLOAT", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("FLOAT", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("BOOLEAN", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("VARCHAR(1024)", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("VARBINARY(1024)", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("DECIMAL(18,0)", Decimal.schema((int)0));
        this.verifyDataTypeMapping("DECIMAL(18,4)", Decimal.schema((int)4));
        this.verifyDataTypeMapping("DATE", Date.SCHEMA);
        this.verifyDataTypeMapping("TIME", Time.SCHEMA);
        this.verifyDataTypeMapping("TIMESTAMP", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("DATE");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("TIME");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("TIMESTAMP");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE TABLE \"myTable\" (\n\"c1\" INT NOT NULL,\n\"c2\" INT NOT NULL,\n\"c3\" VARCHAR(1024) NOT NULL,\n\"c4\" VARCHAR(1024) NULL,\n\"c5\" DATE DEFAULT '2001-03-15',\n\"c6\" TIME DEFAULT '00:00:00.000',\n\"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000',\n\"c8\" DECIMAL(18,4) NULL,\nPRIMARY KEY(\"c1\"))";
        String sql = ((VerticaDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((VerticaDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE \"myTable\" ADD \"c1\" INT NOT NULL", "ALTER TABLE \"myTable\" ADD \"c2\" INT NOT NULL", "ALTER TABLE \"myTable\" ADD \"c3\" VARCHAR(1024) NOT NULL", "ALTER TABLE \"myTable\" ADD \"c4\" VARCHAR(1024) NULL", "ALTER TABLE \"myTable\" ADD \"c5\" DATE DEFAULT '2001-03-15'", "ALTER TABLE \"myTable\" ADD \"c6\" TIME DEFAULT '00:00:00.000'", "ALTER TABLE \"myTable\" ADD \"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000'", "ALTER TABLE \"myTable\" ADD \"c8\" DECIMAL(18,4) NULL"};
        this.assertStatements(sql, statements);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldBuildUpsertStatement() {
        ((VerticaDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"col1\" INT NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INT NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\"))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INT NOT NULL," + System.lineSeparator() + "\"pk2\" INT NOT NULL," + System.lineSeparator() + "\"col1\" INT NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\",\"pk2\"))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE \"myTable\" ADD \"newcol1\" INT NULL");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE \"myTable\" ADD \"newcol1\" INT NULL", "ALTER TABLE \"myTable\" ADD \"newcol2\" INT DEFAULT 42");
    }
}

