/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.SqliteDatabaseDialect;
import io.confluent.connect.jdbc.sink.SqliteHelper;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqliteDatabaseDialectTest
extends BaseDialectTest<SqliteDatabaseDialect> {
    private final SqliteHelper sqliteHelper = new SqliteHelper(this.getClass().getSimpleName());

    @Before
    public void beforeEach() throws Exception {
        this.sqliteHelper.setUp();
    }

    @After
    public void afterEach() throws Exception {
        this.sqliteHelper.tearDown();
    }

    @Override
    protected SqliteDatabaseDialect createDialect() {
        return new SqliteDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:sqlite://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "INTEGER");
        this.assertPrimitiveMapping(Schema.Type.INT16, "INTEGER");
        this.assertPrimitiveMapping(Schema.Type.INT32, "INTEGER");
        this.assertPrimitiveMapping(Schema.Type.INT64, "INTEGER");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "REAL");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "REAL");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "INTEGER");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "BLOB");
        this.assertPrimitiveMapping(Schema.Type.STRING, "TEXT");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "NUMERIC");
        this.assertDecimalMapping(3, "NUMERIC");
        this.assertDecimalMapping(4, "NUMERIC");
        this.assertDecimalMapping(5, "NUMERIC");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("INTEGER", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("INTEGER", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("INTEGER", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("INTEGER", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("REAL", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("REAL", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("INTEGER", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("TEXT", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("BLOB", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("NUMERIC", Decimal.schema((int)0));
        this.verifyDataTypeMapping("NUMERIC", Date.SCHEMA);
        this.verifyDataTypeMapping("NUMERIC", Time.SCHEMA);
        this.verifyDataTypeMapping("NUMERIC", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("NUMERIC");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("NUMERIC");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("NUMERIC");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE TABLE `myTable` (\n`c1` INTEGER NOT NULL,\n`c2` INTEGER NOT NULL,\n`c3` TEXT NOT NULL,\n`c4` TEXT NULL,\n`c5` NUMERIC DEFAULT '2001-03-15',\n`c6` NUMERIC DEFAULT '00:00:00.000',\n`c7` NUMERIC DEFAULT '2001-03-15 00:00:00.000',\n`c8` NUMERIC NULL,\nPRIMARY KEY(`c1`))";
        String sql = ((SqliteDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((SqliteDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE `myTable` ADD `c1` INTEGER NOT NULL", "ALTER TABLE `myTable` ADD `c2` INTEGER NOT NULL", "ALTER TABLE `myTable` ADD `c3` TEXT NOT NULL", "ALTER TABLE `myTable` ADD `c4` TEXT NULL", "ALTER TABLE `myTable` ADD `c5` NUMERIC DEFAULT '2001-03-15'", "ALTER TABLE `myTable` ADD `c6` NUMERIC DEFAULT '00:00:00.000'", "ALTER TABLE `myTable` ADD `c7` NUMERIC DEFAULT '2001-03-15 00:00:00.000'", "ALTER TABLE `myTable` ADD `c8` NUMERIC NULL"};
        this.assertStatements(sql, statements);
    }

    @Test
    public void shouldBuildUpsertStatement() {
        String expected = "INSERT OR REPLACE INTO `myTable`(`id1`,`id2`,`columnA`,`columnB`,`columnC`,`columnD`) VALUES(?,?,?,?,?,?)";
        String sql = ((SqliteDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE TABLE `myTable` (" + System.lineSeparator() + "`col1` INTEGER NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE TABLE `myTable` (" + System.lineSeparator() + "`pk1` INTEGER NOT NULL," + System.lineSeparator() + "PRIMARY KEY(`pk1`))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE TABLE `myTable` (" + System.lineSeparator() + "`pk1` INTEGER NOT NULL," + System.lineSeparator() + "`pk2` INTEGER NOT NULL," + System.lineSeparator() + "`col1` INTEGER NOT NULL," + System.lineSeparator() + "PRIMARY KEY(`pk1`,`pk2`))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE `myTable` ADD `newcol1` INTEGER NULL");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE `myTable` ADD `newcol1` INTEGER NULL", "ALTER TABLE `myTable` ADD `newcol2` INTEGER DEFAULT 42");
    }

    @Test
    public void upsert() {
        TableId book = new TableId(null, null, "Book");
        Assert.assertEquals((Object)"INSERT OR REPLACE INTO `Book`(`author`,`title`,`ISBN`,`year`,`pages`) VALUES(?,?,?,?,?)", (Object)((SqliteDatabaseDialect)this.dialect).buildUpsertQueryStatement(book, this.columns(book, "author", "title"), this.columns(book, "ISBN", "year", "pages")));
    }

    @Test(expected=SQLException.class)
    public void tableOnEmptyDb() throws SQLException {
        TableId tableId = new TableId(null, null, "x");
        ((SqliteDatabaseDialect)this.dialect).describeTable(this.sqliteHelper.connection, tableId);
    }

    @Test
    public void testDescribeTable() throws SQLException {
        TableId tableId = new TableId(null, null, "x");
        this.sqliteHelper.createTable("create table x (id int primary key, name text not null, optional_age int null)");
        TableDefinition defn = ((SqliteDatabaseDialect)this.dialect).describeTable(this.sqliteHelper.connection, tableId);
        Assert.assertEquals((Object)tableId, (Object)defn.id());
        ColumnDefinition columnDefn = defn.definitionForColumn("id");
        Assert.assertEquals((Object)"INT", (Object)columnDefn.typeName());
        Assert.assertEquals((long)4L, (long)columnDefn.type());
        Assert.assertEquals((Object)true, (Object)columnDefn.isPrimaryKey());
        Assert.assertEquals((Object)false, (Object)columnDefn.isOptional());
        columnDefn = defn.definitionForColumn("name");
        Assert.assertEquals((Object)"TEXT", (Object)columnDefn.typeName());
        Assert.assertEquals((long)12L, (long)columnDefn.type());
        Assert.assertEquals((Object)false, (Object)columnDefn.isPrimaryKey());
        Assert.assertEquals((Object)false, (Object)columnDefn.isOptional());
        columnDefn = defn.definitionForColumn("optional_age");
        Assert.assertEquals((Object)"INT", (Object)columnDefn.typeName());
        Assert.assertEquals((long)4L, (long)columnDefn.type());
        Assert.assertEquals((Object)false, (Object)columnDefn.isPrimaryKey());
        Assert.assertEquals((Object)true, (Object)columnDefn.isOptional());
    }
}

