/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.SqlServerDatabaseDialect;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class SqlServerDatabaseDialectTest
extends BaseDialectTest<SqlServerDatabaseDialect> {
    @Override
    protected SqlServerDatabaseDialect createDialect() {
        return new SqlServerDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:sqlsserver://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "tinyint");
        this.assertPrimitiveMapping(Schema.Type.INT16, "smallint");
        this.assertPrimitiveMapping(Schema.Type.INT32, "int");
        this.assertPrimitiveMapping(Schema.Type.INT64, "bigint");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "real");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "float");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "bit");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "varbinary(max)");
        this.assertPrimitiveMapping(Schema.Type.STRING, "varchar(max)");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "decimal(38,0)");
        this.assertDecimalMapping(3, "decimal(38,3)");
        this.assertDecimalMapping(4, "decimal(38,4)");
        this.assertDecimalMapping(5, "decimal(38,5)");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("tinyint", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("smallint", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("int", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("bigint", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("real", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("float", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("bit", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("varchar(max)", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("varbinary(max)", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("decimal(38,0)", Decimal.schema((int)0));
        this.verifyDataTypeMapping("decimal(38,4)", Decimal.schema((int)4));
        this.verifyDataTypeMapping("date", Date.SCHEMA);
        this.verifyDataTypeMapping("time", Time.SCHEMA);
        this.verifyDataTypeMapping("datetime2", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("date");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("time");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("datetime2");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE TABLE [myTable] (\n[c1] int NOT NULL,\n[c2] bigint NOT NULL,\n[c3] varchar(max) NOT NULL,\n[c4] varchar(max) NULL,\n[c5] date DEFAULT '2001-03-15',\n[c6] time DEFAULT '00:00:00.000',\n[c7] datetime2 DEFAULT '2001-03-15 00:00:00.000',\n[c8] decimal(38,4) NULL,\nPRIMARY KEY([c1]))";
        String sql = ((SqlServerDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((SqlServerDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE [myTable] ADD\n[c1] int NOT NULL,\n[c2] bigint NOT NULL,\n[c3] varchar(max) NOT NULL,\n[c4] varchar(max) NULL,\n[c5] date DEFAULT '2001-03-15',\n[c6] time DEFAULT '00:00:00.000',\n[c7] datetime2 DEFAULT '2001-03-15 00:00:00.000',\n[c8] decimal(38,4) NULL"};
        this.assertStatements(sql, statements);
    }

    @Test
    public void shouldBuildUpsertStatement() {
        String expected = "merge into [myTable] with (HOLDLOCK) AS target using (select ? AS [id1], ? AS [id2], ? AS [columnA], ? AS [columnB], ? AS [columnC], ? AS [columnD]) AS incoming on (target.[id1]=incoming.[id1] and target.[id2]=incoming.[id2]) when matched then update set [columnA]=incoming.[columnA],[columnB]=incoming.[columnB],[columnC]=incoming.[columnC],[columnD]=incoming.[columnD] when not matched then insert ([columnA], [columnB], [columnC], [columnD], [id1], [id2]) values (incoming.[columnA],incoming.[columnB],incoming.[columnC],incoming.[columnD],incoming.[id1],incoming.[id2]);";
        String sql = ((SqlServerDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE TABLE [myTable] (" + System.lineSeparator() + "[col1] int NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE TABLE [myTable] (" + System.lineSeparator() + "[pk1] int NOT NULL," + System.lineSeparator() + "PRIMARY KEY([pk1]))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE TABLE [myTable] (" + System.lineSeparator() + "[pk1] int NOT NULL," + System.lineSeparator() + "[pk2] int NOT NULL," + System.lineSeparator() + "[col1] int NOT NULL," + System.lineSeparator() + "PRIMARY KEY([pk1],[pk2]))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE [myTable] ADD" + System.lineSeparator() + "[newcol1] int NULL");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE [myTable] ADD" + System.lineSeparator() + "[newcol1] int NULL," + System.lineSeparator() + "[newcol2] int DEFAULT 42");
    }

    @Test
    public void upsert1() {
        TableId customer = this.tableId("Customer");
        Assert.assertEquals((Object)"merge into [Customer] with (HOLDLOCK) AS target using (select ? AS [id], ? AS [name], ? AS [salary], ? AS [address]) AS incoming on (target.[id]=incoming.[id]) when matched then update set [name]=incoming.[name],[salary]=incoming.[salary],[address]=incoming.[address] when not matched then insert ([name], [salary], [address], [id]) values (incoming.[name],incoming.[salary],incoming.[address],incoming.[id]);", (Object)((SqlServerDatabaseDialect)this.dialect).buildUpsertQueryStatement(customer, this.columns(customer, "id"), this.columns(customer, "name", "salary", "address")));
    }

    @Test
    public void upsert2() {
        TableId book = new TableId(null, null, "Book");
        Assert.assertEquals((Object)"merge into [Book] with (HOLDLOCK) AS target using (select ? AS [author], ? AS [title], ? AS [ISBN], ? AS [year], ? AS [pages]) AS incoming on (target.[author]=incoming.[author] and target.[title]=incoming.[title]) when matched then update set [ISBN]=incoming.[ISBN],[year]=incoming.[year],[pages]=incoming.[pages] when not matched then insert ([ISBN], [year], [pages], [author], [title]) values (incoming.[ISBN],incoming.[year],incoming.[pages],incoming.[author],incoming.[title]);", (Object)((SqlServerDatabaseDialect)this.dialect).buildUpsertQueryStatement(book, this.columns(book, "author", "title"), this.columns(book, "ISBN", "year", "pages")));
    }
}

