/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.SapHanaDatabaseDialect;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class SapHanaDatabaseDialectTest
extends BaseDialectTest<SapHanaDatabaseDialect> {
    @Override
    protected SapHanaDatabaseDialect createDialect() {
        return new SapHanaDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:sap://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "TINYINT");
        this.assertPrimitiveMapping(Schema.Type.INT16, "SMALLINT");
        this.assertPrimitiveMapping(Schema.Type.INT32, "INTEGER");
        this.assertPrimitiveMapping(Schema.Type.INT64, "BIGINT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "REAL");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "DOUBLE");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "BOOLEAN");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "BLOB");
        this.assertPrimitiveMapping(Schema.Type.STRING, "VARCHAR(1000)");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "DECIMAL");
        this.assertDecimalMapping(3, "DECIMAL");
        this.assertDecimalMapping(4, "DECIMAL");
        this.assertDecimalMapping(5, "DECIMAL");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("TINYINT", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("SMALLINT", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("INTEGER", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("BIGINT", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("REAL", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("DOUBLE", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("BOOLEAN", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("VARCHAR(1000)", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("BLOB", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("DECIMAL", Decimal.schema((int)0));
        this.verifyDataTypeMapping("DATE", Date.SCHEMA);
        this.verifyDataTypeMapping("DATE", Time.SCHEMA);
        this.verifyDataTypeMapping("TIMESTAMP", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("DATE");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("DATE");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("TIMESTAMP");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE COLUMN TABLE \"myTable\" (" + System.lineSeparator() + "\"c1\" INTEGER NOT NULL," + System.lineSeparator() + "\"c2\" BIGINT NOT NULL," + System.lineSeparator() + "\"c3\" VARCHAR(1000) NOT NULL," + System.lineSeparator() + "\"c4\" VARCHAR(1000) NULL," + System.lineSeparator() + "\"c5\" DATE DEFAULT '2001-03-15'," + System.lineSeparator() + "\"c6\" DATE DEFAULT '00:00:00.000'," + System.lineSeparator() + "\"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000'," + System.lineSeparator() + "\"c8\" DECIMAL NULL," + System.lineSeparator() + "PRIMARY KEY(\"c1\"))";
        String sql = ((SapHanaDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((SapHanaDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE \"myTable\" ADD(" + System.lineSeparator() + "\"c1\" INTEGER NOT NULL," + System.lineSeparator() + "\"c2\" BIGINT NOT NULL," + System.lineSeparator() + "\"c3\" VARCHAR(1000) NOT NULL," + System.lineSeparator() + "\"c4\" VARCHAR(1000) NULL," + System.lineSeparator() + "\"c5\" DATE DEFAULT '2001-03-15'," + System.lineSeparator() + "\"c6\" DATE DEFAULT '00:00:00.000'," + System.lineSeparator() + "\"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000'," + System.lineSeparator() + "\"c8\" DECIMAL NULL)"};
        this.assertStatements(sql, statements);
    }

    @Test
    public void shouldBuildUpsertStatement() {
        String expected = "UPSERT \"myTable\"(\"id1\",\"id2\",\"columnA\",\"columnB\",\"columnC\",\"columnD\") VALUES(?,?,?,?,?,?) WITH PRIMARY KEY";
        String sql = ((SapHanaDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE COLUMN TABLE \"myTable\" (" + System.lineSeparator() + "\"col1\" INTEGER NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE COLUMN TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INTEGER NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\"))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE COLUMN TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INTEGER NOT NULL," + System.lineSeparator() + "\"pk2\" INTEGER NOT NULL," + System.lineSeparator() + "\"col1\" INTEGER NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\",\"pk2\"))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE \"myTable\" ADD(" + System.lineSeparator() + "\"newcol1\" INTEGER NULL)");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE \"myTable\" ADD(" + System.lineSeparator() + "\"newcol1\" INTEGER NULL," + System.lineSeparator() + "\"newcol2\" INTEGER DEFAULT 42)");
    }

    @Test
    public void upsert() {
        TableId tableA = this.tableId("tableA");
        Assert.assertEquals((Object)"UPSERT \"tableA\"(\"col1\",\"col2\",\"col3\",\"col4\") VALUES(?,?,?,?) WITH PRIMARY KEY", (Object)((SapHanaDatabaseDialect)this.dialect).buildUpsertQueryStatement(tableA, this.columns(tableA, "col1"), this.columns(tableA, "col2", "col3", "col4")));
    }
}

