/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.PostgreSqlDatabaseDialect;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSqlDatabaseDialectTest
extends BaseDialectTest<PostgreSqlDatabaseDialect> {
    @Override
    protected PostgreSqlDatabaseDialect createDialect() {
        return new PostgreSqlDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:postgresql://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "SMALLINT");
        this.assertPrimitiveMapping(Schema.Type.INT16, "SMALLINT");
        this.assertPrimitiveMapping(Schema.Type.INT32, "INT");
        this.assertPrimitiveMapping(Schema.Type.INT64, "BIGINT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "REAL");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "DOUBLE PRECISION");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "BOOLEAN");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "BLOB");
        this.assertPrimitiveMapping(Schema.Type.STRING, "TEXT");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "DECIMAL");
        this.assertDecimalMapping(3, "DECIMAL");
        this.assertDecimalMapping(4, "DECIMAL");
        this.assertDecimalMapping(5, "DECIMAL");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("SMALLINT", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("SMALLINT", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("INT", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("BIGINT", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("REAL", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("DOUBLE PRECISION", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("BOOLEAN", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("TEXT", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("BLOB", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("DECIMAL", Decimal.schema((int)0));
        this.verifyDataTypeMapping("DATE", Date.SCHEMA);
        this.verifyDataTypeMapping("TIME", Time.SCHEMA);
        this.verifyDataTypeMapping("TIMESTAMP", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("DATE");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("TIME");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("TIMESTAMP");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE TABLE \"myTable\" (\n\"c1\" INT NOT NULL,\n\"c2\" BIGINT NOT NULL,\n\"c3\" TEXT NOT NULL,\n\"c4\" TEXT NULL,\n\"c5\" DATE DEFAULT '2001-03-15',\n\"c6\" TIME DEFAULT '00:00:00.000',\n\"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000',\n\"c8\" DECIMAL NULL,\nPRIMARY KEY(\"c1\"))";
        String sql = ((PostgreSqlDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((PostgreSqlDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE \"myTable\" \nADD \"c1\" INT NOT NULL,\nADD \"c2\" BIGINT NOT NULL,\nADD \"c3\" TEXT NOT NULL,\nADD \"c4\" TEXT NULL,\nADD \"c5\" DATE DEFAULT '2001-03-15',\nADD \"c6\" TIME DEFAULT '00:00:00.000',\nADD \"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000',\nADD \"c8\" DECIMAL NULL"};
        this.assertStatements(sql, statements);
    }

    @Test
    public void shouldBuildUpsertStatement() {
        String expected = "INSERT INTO \"myTable\" (\"id1\",\"id2\",\"columnA\",\"columnB\",\"columnC\",\"columnD\") VALUES (?,?,?,?,?,?) ON CONFLICT (\"id1\",\"id2\") DO UPDATE SET \"columnA\"=EXCLUDED.\"columnA\",\"columnB\"=EXCLUDED.\"columnB\",\"columnC\"=EXCLUDED.\"columnC\",\"columnD\"=EXCLUDED.\"columnD\"";
        String sql = ((PostgreSqlDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"col1\" INT NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INT NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\"))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INT NOT NULL," + System.lineSeparator() + "\"pk2\" INT NOT NULL," + System.lineSeparator() + "\"col1\" INT NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\",\"pk2\"))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE \"myTable\" ADD \"newcol1\" INT NULL");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE \"myTable\" " + System.lineSeparator() + "ADD \"newcol1\" INT NULL," + System.lineSeparator() + "ADD \"newcol2\" INT DEFAULT 42");
    }

    @Test
    public void upsert() {
        TableId customer = this.tableId("Customer");
        Assert.assertEquals((Object)"INSERT INTO \"Customer\" (\"id\",\"name\",\"salary\",\"address\") VALUES (?,?,?,?) ON CONFLICT (\"id\") DO UPDATE SET \"name\"=EXCLUDED.\"name\",\"salary\"=EXCLUDED.\"salary\",\"address\"=EXCLUDED.\"address\"", (Object)((PostgreSqlDatabaseDialect)this.dialect).buildUpsertQueryStatement(customer, this.columns(customer, "id"), this.columns(customer, "name", "salary", "address")));
    }
}

