/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.OracleDatabaseDialect;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class OracleDatabaseDialectTest
extends BaseDialectTest<OracleDatabaseDialect> {
    @Override
    protected OracleDatabaseDialect createDialect() {
        return new OracleDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:oracle:thin://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "NUMBER(3,0)");
        this.assertPrimitiveMapping(Schema.Type.INT16, "NUMBER(5,0)");
        this.assertPrimitiveMapping(Schema.Type.INT32, "NUMBER(10,0)");
        this.assertPrimitiveMapping(Schema.Type.INT64, "NUMBER(19,0)");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "BINARY_FLOAT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "BINARY_DOUBLE");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "NUMBER(1,0)");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "BLOB");
        this.assertPrimitiveMapping(Schema.Type.STRING, "CLOB");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "NUMBER(*,0)");
        this.assertDecimalMapping(3, "NUMBER(*,3)");
        this.assertDecimalMapping(4, "NUMBER(*,4)");
        this.assertDecimalMapping(5, "NUMBER(*,5)");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("NUMBER(3,0)", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("NUMBER(5,0)", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("NUMBER(10,0)", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("NUMBER(19,0)", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("BINARY_FLOAT", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("BINARY_DOUBLE", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("NUMBER(1,0)", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("CLOB", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("BLOB", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("NUMBER(*,0)", Decimal.schema((int)0));
        this.verifyDataTypeMapping("NUMBER(*,42)", Decimal.schema((int)42));
        this.verifyDataTypeMapping("DATE", Date.SCHEMA);
        this.verifyDataTypeMapping("DATE", Time.SCHEMA);
        this.verifyDataTypeMapping("TIMESTAMP", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("DATE");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("DATE");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("TIMESTAMP");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE TABLE \"myTable\" (\n\"c1\" NUMBER(10,0) NOT NULL,\n\"c2\" NUMBER(19,0) NOT NULL,\n\"c3\" CLOB NOT NULL,\n\"c4\" CLOB NULL,\n\"c5\" DATE DEFAULT '2001-03-15',\n\"c6\" DATE DEFAULT '00:00:00.000',\n\"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000',\n\"c8\" NUMBER(*,4) NULL,\nPRIMARY KEY(\"c1\"))";
        String sql = ((OracleDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((OracleDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE \"myTable\" ADD(\n\"c1\" NUMBER(10,0) NOT NULL,\n\"c2\" NUMBER(19,0) NOT NULL,\n\"c3\" CLOB NOT NULL,\n\"c4\" CLOB NULL,\n\"c5\" DATE DEFAULT '2001-03-15',\n\"c6\" DATE DEFAULT '00:00:00.000',\n\"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000',\n\"c8\" NUMBER(*,4) NULL)"};
        this.assertStatements(sql, statements);
    }

    @Test
    public void shouldBuildUpsertStatement() {
        String expected = "merge into \"myTable\" using (select ? \"id1\", ? \"id2\", ? \"columnA\", ? \"columnB\", ? \"columnC\", ? \"columnD\" FROM dual) incoming on(\"myTable\".\"id1\"=incoming.\"id1\" and \"myTable\".\"id2\"=incoming.\"id2\") when matched then update set \"myTable\".\"columnA\"=incoming.\"columnA\",\"myTable\".\"columnB\"=incoming.\"columnB\",\"myTable\".\"columnC\"=incoming.\"columnC\",\"myTable\".\"columnD\"=incoming.\"columnD\" when not matched then insert(\"myTable\".\"columnA\",\"myTable\".\"columnB\",\"myTable\".\"columnC\",\"myTable\".\"columnD\",\"myTable\".\"id1\",\"myTable\".\"id2\") values(incoming.\"columnA\",incoming.\"columnB\",incoming.\"columnC\",incoming.\"columnD\",incoming.\"id1\",incoming.\"id2\")";
        String sql = ((OracleDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"col1\" NUMBER(10,0) NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" NUMBER(10,0) NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\"))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" NUMBER(10,0) NOT NULL," + System.lineSeparator() + "\"pk2\" NUMBER(10,0) NOT NULL," + System.lineSeparator() + "\"col1\" NUMBER(10,0) NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\",\"pk2\"))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE \"myTable\" ADD(" + System.lineSeparator() + "\"newcol1\" NUMBER(10,0) NULL)");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE \"myTable\" ADD(" + System.lineSeparator() + "\"newcol1\" NUMBER(10,0) NULL," + System.lineSeparator() + "\"newcol2\" NUMBER(10,0) DEFAULT 42)");
    }

    @Test
    public void upsert() {
        TableId article = this.tableId("ARTICLE");
        String expected = "merge into \"ARTICLE\" using (select ? \"title\", ? \"author\", ? \"body\" FROM dual) incoming on(\"ARTICLE\".\"title\"=incoming.\"title\" and \"ARTICLE\".\"author\"=incoming.\"author\") when matched then update set \"ARTICLE\".\"body\"=incoming.\"body\" when not matched then insert(\"ARTICLE\".\"body\",\"ARTICLE\".\"title\",\"ARTICLE\".\"author\") values(incoming.\"body\",incoming.\"title\",incoming.\"author\")";
        String actual = ((OracleDatabaseDialect)this.dialect).buildUpsertQueryStatement(article, this.columns(article, "title", "author"), this.columns(article, "body"));
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

