/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.MySqlDatabaseDialect;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class MySqlDatabaseDialectTest
extends BaseDialectTest<MySqlDatabaseDialect> {
    @Override
    protected MySqlDatabaseDialect createDialect() {
        return new MySqlDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:mysql://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "TINYINT");
        this.assertPrimitiveMapping(Schema.Type.INT16, "SMALLINT");
        this.assertPrimitiveMapping(Schema.Type.INT32, "INT");
        this.assertPrimitiveMapping(Schema.Type.INT64, "BIGINT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "FLOAT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "DOUBLE");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "TINYINT");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "VARBINARY(1024)");
        this.assertPrimitiveMapping(Schema.Type.STRING, "VARCHAR(256)");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "DECIMAL(65,0)");
        this.assertDecimalMapping(3, "DECIMAL(65,3)");
        this.assertDecimalMapping(4, "DECIMAL(65,4)");
        this.assertDecimalMapping(5, "DECIMAL(65,5)");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("TINYINT", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("SMALLINT", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("INT", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("BIGINT", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("FLOAT", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("DOUBLE", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("TINYINT", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("VARCHAR(256)", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("VARBINARY(1024)", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("DECIMAL(65,0)", Decimal.schema((int)0));
        this.verifyDataTypeMapping("DECIMAL(65,2)", Decimal.schema((int)2));
        this.verifyDataTypeMapping("DATE", Date.SCHEMA);
        this.verifyDataTypeMapping("TIME(3)", Time.SCHEMA);
        this.verifyDataTypeMapping("DATETIME(3)", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("DATE");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("TIME(3)");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("DATETIME(3)");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE TABLE `myTable` (\n`c1` INT NOT NULL,\n`c2` BIGINT NOT NULL,\n`c3` VARCHAR(256) NOT NULL,\n`c4` VARCHAR(256) NULL,\n`c5` DATE DEFAULT '2001-03-15',\n`c6` TIME(3) DEFAULT '00:00:00.000',\n`c7` DATETIME(3) DEFAULT '2001-03-15 00:00:00.000',\n`c8` DECIMAL(65,4) NULL,\nPRIMARY KEY(`c1`))";
        String sql = ((MySqlDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((MySqlDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE `myTable` \nADD `c1` INT NOT NULL,\nADD `c2` BIGINT NOT NULL,\nADD `c3` VARCHAR(256) NOT NULL,\nADD `c4` VARCHAR(256) NULL,\nADD `c5` DATE DEFAULT '2001-03-15',\nADD `c6` TIME(3) DEFAULT '00:00:00.000',\nADD `c7` DATETIME(3) DEFAULT '2001-03-15 00:00:00.000',\nADD `c8` DECIMAL(65,4) NULL"};
        this.assertStatements(sql, statements);
    }

    @Test
    public void shouldBuildUpsertStatement() {
        String expected = "insert into `myTable`(`id1`,`id2`,`columnA`,`columnB`,`columnC`,`columnD`) values(?,?,?,?,?,?) on duplicate key update `columnA`=values(`columnA`),`columnB`=values(`columnB`),`columnC`=values(`columnC`),`columnD`=values(`columnD`)";
        String sql = ((MySqlDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE TABLE `myTable` (" + System.lineSeparator() + "`col1` INT NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE TABLE `myTable` (" + System.lineSeparator() + "`pk1` INT NOT NULL," + System.lineSeparator() + "PRIMARY KEY(`pk1`))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE TABLE `myTable` (" + System.lineSeparator() + "`pk1` INT NOT NULL," + System.lineSeparator() + "`pk2` INT NOT NULL," + System.lineSeparator() + "`col1` INT NOT NULL," + System.lineSeparator() + "PRIMARY KEY(`pk1`,`pk2`))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE `myTable` ADD `newcol1` INT NULL");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE `myTable` " + System.lineSeparator() + "ADD `newcol1` INT NULL," + System.lineSeparator() + "ADD `newcol2` INT DEFAULT 42");
    }

    @Test
    public void upsert() {
        TableId actor = this.tableId("actor");
        String expected = "insert into `actor`(`actor_id`,`first_name`,`last_name`,`score`) values(?,?,?,?) on duplicate key update `first_name`=values(`first_name`),`last_name`=values(`last_name`),`score`=values(`score`)";
        String sql = ((MySqlDatabaseDialect)this.dialect).buildUpsertQueryStatement(actor, this.columns(actor, "actor_id"), this.columns(actor, "first_name", "last_name", "score"));
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void upsertOnlyKeyCols() {
        TableId actor = this.tableId("actor");
        String expected = "insert into `actor`(`actor_id`) values(?) on duplicate key update `actor_id`=values(`actor_id`)";
        String sql = ((MySqlDatabaseDialect)this.dialect).buildUpsertQueryStatement(actor, this.columns(actor, "actor_id"), this.columns(actor, new String[0]));
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void insert() {
        TableId customers = this.tableId("customers");
        String expected = "INSERT INTO `customers`(`age`,`firstName`,`lastName`) VALUES(?,?,?)";
        String sql = ((MySqlDatabaseDialect)this.dialect).buildInsertStatement(customers, this.columns(customers, new String[0]), this.columns(customers, "age", "firstName", "lastName"));
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void update() {
        TableId customers = this.tableId("customers");
        String expected = "UPDATE `customers` SET `age` = ?, `firstName` = ?, `lastName` = ? WHERE `id` = ?";
        String sql = ((MySqlDatabaseDialect)this.dialect).buildUpdateStatement(customers, this.columns(customers, "id"), this.columns(customers, "age", "firstName", "lastName"));
        Assert.assertEquals((Object)expected, (Object)sql);
    }
}

