/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.SqliteHelper;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.source.EmbeddedDerby;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ConnectionProvider;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.StringUtils;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GenericDatabaseDialectTest
extends BaseDialectTest<GenericDatabaseDialect> {
    public static final Set<String> TABLE_TYPES = Collections.singleton("TABLE");
    private final SqliteHelper sqliteHelper = new SqliteHelper(this.getClass().getSimpleName());
    private Map<String, String> connProps;
    private JdbcSourceConnectorConfig config;
    private EmbeddedDerby db;
    private ConnectionProvider connectionProvider;
    private Connection conn;

    @Override
    @Before
    public void setup() throws Exception {
        this.db = new EmbeddedDerby();
        this.connProps = new HashMap<String, String>();
        this.connProps.put("connection.url", this.db.getUrl());
        this.connProps.put("mode", "bulk");
        this.connProps.put("topic.prefix", "test-");
        this.newDialectFor(null, null);
        super.setup();
        this.connectionProvider = this.dialect;
        this.conn = this.connectionProvider.getConnection();
    }

    @After
    public void cleanup() throws Exception {
        this.connectionProvider.close();
        this.conn.close();
        this.db.close();
        this.db.dropDatabase();
    }

    @Override
    protected GenericDatabaseDialect createDialect() {
        return new GenericDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl(this.db.getUrl(), new String[0]));
    }

    protected GenericDatabaseDialect createDialect(AbstractConfig config) {
        return new GenericDatabaseDialect(config);
    }

    protected GenericDatabaseDialect newDialectFor(Set<String> tableTypes, String schemaPattern) {
        if (schemaPattern != null) {
            this.connProps.put("schema.pattern", schemaPattern);
        } else {
            this.connProps.remove("schema.pattern");
        }
        if (tableTypes != null) {
            this.connProps.put("table.types", StringUtils.join(tableTypes, (String)","));
        } else {
            this.connProps.remove("table.types");
        }
        this.config = new JdbcSourceConnectorConfig(this.connProps);
        this.dialect = this.createDialect((AbstractConfig)this.config);
        return this.dialect;
    }

    @Test
    public void testGetTablesEmpty() throws Exception {
        this.newDialectFor(TABLE_TYPES, null);
        Assert.assertEquals(Collections.emptyList(), (Object)this.dialect.tableIds(this.conn));
    }

    @Test
    public void testGetTablesSingle() throws Exception {
        this.newDialectFor(TABLE_TYPES, null);
        this.db.createTable("test", "id", "INT");
        TableId test = new TableId(null, "APP", "test");
        Assert.assertEquals(Arrays.asList(test), (Object)this.dialect.tableIds(this.conn));
    }

    @Test
    public void testFindTablesWithKnownTableType() throws Exception {
        Set<String> types = Collections.singleton("TABLE");
        this.newDialectFor(types, null);
        this.db.createTable("test", "id", "INT");
        TableId test = new TableId(null, "APP", "test");
        Assert.assertEquals(Arrays.asList(test), (Object)this.dialect.tableIds(this.conn));
    }

    @Test
    public void testNotFindTablesWithUnknownTableType() throws Exception {
        this.newDialectFor(Collections.singleton("view"), null);
        this.db.createTable("test", "id", "INT");
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.dialect.tableIds(this.conn));
    }

    @Test
    public void testGetTablesMany() throws Exception {
        this.newDialectFor(TABLE_TYPES, null);
        this.db.createTable("test", "id", "INT");
        this.db.createTable("foo", "id", "INT", "bar", "VARCHAR(20)");
        this.db.createTable("zab", "id", "INT");
        TableId test = new TableId(null, "APP", "test");
        TableId foo = new TableId(null, "APP", "foo");
        TableId zab = new TableId(null, "APP", "zab");
        Assert.assertEquals(new HashSet<TableId>(Arrays.asList(test, foo, zab)), new HashSet(this.dialect.tableIds(this.conn)));
    }

    @Test
    public void testGetTablesNarrowedToSchemas() throws Exception {
        this.db.createTable("some_table", "id", "INT");
        this.db.execute("CREATE SCHEMA PUBLIC_SCHEMA");
        this.db.execute("SET SCHEMA PUBLIC_SCHEMA");
        this.db.createTable("public_table", "id", "INT");
        this.db.execute("CREATE SCHEMA PRIVATE_SCHEMA");
        this.db.execute("SET SCHEMA PRIVATE_SCHEMA");
        this.db.createTable("private_table", "id", "INT");
        this.db.createTable("another_private_table", "id", "INT");
        TableId someTable = new TableId(null, "APP", "some_table");
        TableId publicTable = new TableId(null, "PUBLIC_SCHEMA", "public_table");
        TableId privateTable = new TableId(null, "PRIVATE_SCHEMA", "private_table");
        TableId anotherPrivateTable = new TableId(null, "PRIVATE_SCHEMA", "another_private_table");
        this.assertTableNames(TABLE_TYPES, "PUBLIC_SCHEMA", publicTable);
        this.assertTableNames(TABLE_TYPES, "PRIVATE_SCHEMA", privateTable, anotherPrivateTable);
        this.assertTableNames(TABLE_TYPES, null, someTable, publicTable, privateTable, anotherPrivateTable);
        Set<String> types = Collections.singleton("TABLE");
        this.assertTableNames(types, "PUBLIC_SCHEMA", publicTable);
        this.assertTableNames(types, "PRIVATE_SCHEMA", privateTable, anotherPrivateTable);
        this.assertTableNames(types, null, someTable, publicTable, privateTable, anotherPrivateTable);
        TableDefinition defn = this.dialect.describeTable(this.db.getConnection(), someTable);
        Assert.assertEquals((Object)someTable, (Object)defn.id());
        Assert.assertEquals((Object)"INTEGER", (Object)defn.definitionForColumn("id").typeName());
        defn = this.dialect.describeTable(this.db.getConnection(), publicTable);
        Assert.assertEquals((Object)publicTable, (Object)defn.id());
        Assert.assertEquals((Object)"INTEGER", (Object)defn.definitionForColumn("id").typeName());
        defn = this.dialect.describeTable(this.db.getConnection(), privateTable);
        Assert.assertEquals((Object)privateTable, (Object)defn.id());
        Assert.assertEquals((Object)"INTEGER", (Object)defn.definitionForColumn("id").typeName());
        defn = this.dialect.describeTable(this.db.getConnection(), anotherPrivateTable);
        Assert.assertEquals((Object)anotherPrivateTable, (Object)defn.id());
        Assert.assertEquals((Object)"INTEGER", (Object)defn.definitionForColumn("id").typeName());
    }

    protected void assertTableNames(Set<String> tableTypes, String schemaPattern, TableId ... expectedTableIds) throws Exception {
        this.newDialectFor(tableTypes, schemaPattern);
        List ids = this.dialect.tableIds(this.db.getConnection());
        for (TableId expectedTableId : expectedTableIds) {
            Assert.assertTrue((boolean)ids.contains(expectedTableId));
        }
        Assert.assertEquals((long)expectedTableIds.length, (long)ids.size());
    }

    @Test
    public void testDescribeTableOnEmptyDb() throws SQLException {
        TableId someTable = new TableId(null, "APP", "some_table");
        TableDefinition defn = this.dialect.describeTable(this.db.getConnection(), someTable);
        Assert.assertNull((Object)defn);
    }

    @Test
    public void testDescribeTable() throws SQLException {
        TableId tableId = new TableId(null, "APP", "x");
        this.db.createTable("x", "id", "INTEGER PRIMARY KEY", "name", "VARCHAR(255) not null", "optional_age", "INTEGER");
        TableDefinition defn = this.dialect.describeTable(this.db.getConnection(), tableId);
        Assert.assertEquals((Object)tableId, (Object)defn.id());
        ColumnDefinition columnDefn = defn.definitionForColumn("id");
        Assert.assertEquals((Object)"INTEGER", (Object)columnDefn.typeName());
        Assert.assertEquals((long)4L, (long)columnDefn.type());
        Assert.assertEquals((Object)true, (Object)columnDefn.isPrimaryKey());
        Assert.assertEquals((Object)false, (Object)columnDefn.isOptional());
        columnDefn = defn.definitionForColumn("name");
        Assert.assertEquals((Object)"VARCHAR", (Object)columnDefn.typeName());
        Assert.assertEquals((long)12L, (long)columnDefn.type());
        Assert.assertEquals((Object)false, (Object)columnDefn.isPrimaryKey());
        Assert.assertEquals((Object)false, (Object)columnDefn.isOptional());
        columnDefn = defn.definitionForColumn("optional_age");
        Assert.assertEquals((Object)"INTEGER", (Object)columnDefn.typeName());
        Assert.assertEquals((long)4L, (long)columnDefn.type());
        Assert.assertEquals((Object)false, (Object)columnDefn.isPrimaryKey());
        Assert.assertEquals((Object)true, (Object)columnDefn.isOptional());
    }

    @Test
    public void testDescribeColumns() throws Exception {
        this.db.createTable("test", "id", "INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY", "bar", "INTEGER");
        TableId test = new TableId(null, "APP", "test");
        ColumnId id = new ColumnId(test, "id");
        ColumnId bar = new ColumnId(test, "bar");
        Map defns = this.dialect.describeColumns(this.db.getConnection(), "test", null);
        System.out.println("defns = " + defns);
        Assert.assertTrue((boolean)((ColumnDefinition)defns.get(id)).isAutoIncrement());
        Assert.assertFalse((boolean)((ColumnDefinition)defns.get(bar)).isAutoIncrement());
        Assert.assertFalse((boolean)((ColumnDefinition)defns.get(id)).isOptional());
        Assert.assertTrue((boolean)((ColumnDefinition)defns.get(bar)).isOptional());
        this.db.createTable("none", "id", "INTEGER", "bar", "INTEGER");
        TableId none = new TableId(null, "APP", "none");
        id = new ColumnId(none, "id");
        bar = new ColumnId(none, "bar");
        defns = this.dialect.describeColumns(this.db.getConnection(), "none", null);
        Assert.assertFalse((boolean)((ColumnDefinition)defns.get(id)).isAutoIncrement());
        Assert.assertFalse((boolean)((ColumnDefinition)defns.get(bar)).isAutoIncrement());
        Assert.assertTrue((boolean)((ColumnDefinition)defns.get(id)).isOptional());
        Assert.assertTrue((boolean)((ColumnDefinition)defns.get(bar)).isOptional());
        this.db.createTable("mixed", "foo", "INTEGER", "id", "INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY", "bar", "INTEGER");
        TableId mixed = new TableId(null, "APP", "mixed");
        ColumnId foo = new ColumnId(mixed, "foo");
        id = new ColumnId(mixed, "id");
        bar = new ColumnId(mixed, "bar");
        defns = this.dialect.describeColumns(this.db.getConnection(), "mixed", null);
        Assert.assertFalse((boolean)((ColumnDefinition)defns.get(foo)).isAutoIncrement());
        Assert.assertTrue((boolean)((ColumnDefinition)defns.get(id)).isAutoIncrement());
        Assert.assertFalse((boolean)((ColumnDefinition)defns.get(bar)).isAutoIncrement());
        this.db.createTable("tstest", "ts", "TIMESTAMP NOT NULL", "tsdefault", "TIMESTAMP", "tsnull", "TIMESTAMP DEFAULT NULL");
        TableId tstest = new TableId(null, "APP", "tstest");
        ColumnId ts = new ColumnId(tstest, "ts");
        ColumnId tsdefault = new ColumnId(tstest, "tsdefault");
        ColumnId tsnull = new ColumnId(tstest, "tsnull");
        defns = this.dialect.describeColumns(this.db.getConnection(), "tstest", null);
        Assert.assertFalse((boolean)((ColumnDefinition)defns.get(ts)).isOptional());
        Assert.assertTrue((boolean)((ColumnDefinition)defns.get(tsdefault)).isOptional());
        Assert.assertTrue((boolean)((ColumnDefinition)defns.get(tsnull)).isOptional());
    }

    @Test(expected=ConnectException.class)
    public void shouldBuildCreateQueryStatement() {
        this.dialect.buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
    }

    @Test(expected=ConnectException.class)
    public void shouldBuildAlterTableStatement() {
        this.dialect.buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldBuildUpsertStatement() {
        this.dialect.buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
    }

    @Test
    public void formatColumnValue() {
        this.verifyFormatColumnValue("42", Schema.INT8_SCHEMA, (byte)42);
        this.verifyFormatColumnValue("42", Schema.INT16_SCHEMA, (short)42);
        this.verifyFormatColumnValue("42", Schema.INT32_SCHEMA, 42);
        this.verifyFormatColumnValue("42", Schema.INT64_SCHEMA, 42L);
        this.verifyFormatColumnValue("42.5", Schema.FLOAT32_SCHEMA, Float.valueOf(42.5f));
        this.verifyFormatColumnValue("42.5", Schema.FLOAT64_SCHEMA, 42.5);
        this.verifyFormatColumnValue("0", Schema.BOOLEAN_SCHEMA, false);
        this.verifyFormatColumnValue("1", Schema.BOOLEAN_SCHEMA, true);
        this.verifyFormatColumnValue("'quoteit'", Schema.STRING_SCHEMA, "quoteit");
        this.verifyFormatColumnValue("x'2A'", Schema.BYTES_SCHEMA, new byte[]{42});
        this.verifyFormatColumnValue("42.42", Decimal.schema((int)2), new BigDecimal("42.42"));
        Date instant = new Date(1474661402123L);
        this.verifyFormatColumnValue("'2016-09-23'", org.apache.kafka.connect.data.Date.SCHEMA, instant);
        this.verifyFormatColumnValue("'20:10:02.123'", Time.SCHEMA, instant);
        this.verifyFormatColumnValue("'2016-09-23 20:10:02.123'", Timestamp.SCHEMA, instant);
    }

    private void verifyFormatColumnValue(String expected, Schema schema, Object value) {
        GenericDatabaseDialect dialect = this.dummyDialect();
        ExpressionBuilder builder = dialect.expressionBuilder();
        dialect.formatColumnValue(builder, schema.name(), schema.parameters(), schema.type(), value);
        Assert.assertEquals((Object)expected, (Object)builder.toString());
    }

    private void verifyWriteColumnSpec(String expected, SinkRecordField field) {
        GenericDatabaseDialect dialect = this.dummyDialect();
        ExpressionBuilder builder = dialect.expressionBuilder();
        dialect.writeColumnSpec(builder, field);
        Assert.assertEquals((Object)expected, (Object)builder.toString());
    }

    private GenericDatabaseDialect dummyDialect() {
        IdentifierRules rules = new IdentifierRules(",", "`", "`");
        return new GenericDatabaseDialect((AbstractConfig)this.config, rules){

            protected String getSqlType(SinkRecordField f) {
                return "DUMMY";
            }
        };
    }

    @Test
    public void writeColumnSpec() {
        this.verifyWriteColumnSpec("\"foo\" DUMMY DEFAULT 42", new SinkRecordField(SchemaBuilder.int32().defaultValue((Object)42).build(), "foo", true));
        this.verifyWriteColumnSpec("\"foo\" DUMMY DEFAULT 42", new SinkRecordField(SchemaBuilder.int32().defaultValue((Object)42).build(), "foo", false));
        this.verifyWriteColumnSpec("\"foo\" DUMMY DEFAULT 42", new SinkRecordField(SchemaBuilder.int32().optional().defaultValue((Object)42).build(), "foo", true));
        this.verifyWriteColumnSpec("\"foo\" DUMMY DEFAULT 42", new SinkRecordField(SchemaBuilder.int32().optional().defaultValue((Object)42).build(), "foo", false));
        this.verifyWriteColumnSpec("\"foo\" DUMMY NOT NULL", new SinkRecordField(Schema.INT32_SCHEMA, "foo", true));
        this.verifyWriteColumnSpec("\"foo\" DUMMY NOT NULL", new SinkRecordField(Schema.INT32_SCHEMA, "foo", false));
        this.verifyWriteColumnSpec("\"foo\" DUMMY NOT NULL", new SinkRecordField(Schema.OPTIONAL_INT32_SCHEMA, "foo", true));
        this.verifyWriteColumnSpec("\"foo\" DUMMY NULL", new SinkRecordField(Schema.OPTIONAL_INT32_SCHEMA, "foo", false));
    }
}

