/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.BaseDialectTest;
import io.confluent.connect.jdbc.dialect.DerbyDatabaseDialect;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DerbyDatabaseDialectTest
extends BaseDialectTest<DerbyDatabaseDialect> {
    @Override
    protected DerbyDatabaseDialect createDialect() {
        return new DerbyDatabaseDialect((AbstractConfig)this.sourceConfigWithUrl("jdbc:derby://something", new String[0]));
    }

    @Test
    public void shouldMapPrimitiveSchemaTypeToSqlTypes() {
        this.assertPrimitiveMapping(Schema.Type.INT8, "SMALLINT");
        this.assertPrimitiveMapping(Schema.Type.INT16, "SMALLINT");
        this.assertPrimitiveMapping(Schema.Type.INT32, "INTEGER");
        this.assertPrimitiveMapping(Schema.Type.INT64, "BIGINT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT32, "FLOAT");
        this.assertPrimitiveMapping(Schema.Type.FLOAT64, "DOUBLE");
        this.assertPrimitiveMapping(Schema.Type.BOOLEAN, "SMALLINT");
        this.assertPrimitiveMapping(Schema.Type.BYTES, "BLOB(64000)");
        this.assertPrimitiveMapping(Schema.Type.STRING, "VARCHAR(32672)");
    }

    @Test
    public void shouldMapDecimalSchemaTypeToDecimalSqlType() {
        this.assertDecimalMapping(0, "DECIMAL(31,0)");
        this.assertDecimalMapping(5, "DECIMAL(31,5)");
    }

    @Test
    public void shouldMapDataTypes() {
        this.verifyDataTypeMapping("SMALLINT", Schema.INT8_SCHEMA);
        this.verifyDataTypeMapping("SMALLINT", Schema.INT16_SCHEMA);
        this.verifyDataTypeMapping("INTEGER", Schema.INT32_SCHEMA);
        this.verifyDataTypeMapping("BIGINT", Schema.INT64_SCHEMA);
        this.verifyDataTypeMapping("FLOAT", Schema.FLOAT32_SCHEMA);
        this.verifyDataTypeMapping("DOUBLE", Schema.FLOAT64_SCHEMA);
        this.verifyDataTypeMapping("SMALLINT", Schema.BOOLEAN_SCHEMA);
        this.verifyDataTypeMapping("VARCHAR(32672)", Schema.STRING_SCHEMA);
        this.verifyDataTypeMapping("BLOB(64000)", Schema.BYTES_SCHEMA);
        this.verifyDataTypeMapping("DECIMAL(31,0)", Decimal.schema((int)0));
        this.verifyDataTypeMapping("DECIMAL(31,2)", Decimal.schema((int)2));
        this.verifyDataTypeMapping("DATE", Date.SCHEMA);
        this.verifyDataTypeMapping("TIME", Time.SCHEMA);
        this.verifyDataTypeMapping("TIMESTAMP", Timestamp.SCHEMA);
    }

    @Test
    public void shouldMapDateSchemaTypeToDateSqlType() {
        this.assertDateMapping("DATE");
    }

    @Test
    public void shouldMapTimeSchemaTypeToTimeSqlType() {
        this.assertTimeMapping("TIME");
    }

    @Test
    public void shouldMapTimestampSchemaTypeToTimestampSqlType() {
        this.assertTimestampMapping("TIMESTAMP");
    }

    @Test
    public void shouldBuildCreateQueryStatement() {
        String expected = "CREATE TABLE \"myTable\" (\n\"c1\" INTEGER NOT NULL,\n\"c2\" BIGINT NOT NULL,\n\"c3\" VARCHAR(32672) NOT NULL,\n\"c4\" VARCHAR(32672) NULL,\n\"c5\" DATE DEFAULT '2001-03-15',\n\"c6\" TIME DEFAULT '00:00:00.000',\n\"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000',\n\"c8\" DECIMAL(31,4) NULL,\nPRIMARY KEY(\"c1\"))";
        String sql = ((DerbyDatabaseDialect)this.dialect).buildCreateTableStatement(this.tableId, (Collection)this.sinkRecordFields);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void shouldBuildAlterTableStatement() {
        List statements = ((DerbyDatabaseDialect)this.dialect).buildAlterTable(this.tableId, (Collection)this.sinkRecordFields);
        String[] sql = new String[]{"ALTER TABLE \"myTable\" \nADD \"c1\" INTEGER NOT NULL,\nADD \"c2\" BIGINT NOT NULL,\nADD \"c3\" VARCHAR(32672) NOT NULL,\nADD \"c4\" VARCHAR(32672) NULL,\nADD \"c5\" DATE DEFAULT '2001-03-15',\nADD \"c6\" TIME DEFAULT '00:00:00.000',\nADD \"c7\" TIMESTAMP DEFAULT '2001-03-15 00:00:00.000',\nADD \"c8\" DECIMAL(31,4) NULL"};
        this.assertStatements(sql, statements);
    }

    @Test
    public void createOneColNoPk() {
        this.verifyCreateOneColNoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"col1\" INTEGER NOT NULL)");
    }

    @Test
    public void createOneColOnePk() {
        this.verifyCreateOneColOnePk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INTEGER NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\"))");
    }

    @Test
    public void createThreeColTwoPk() {
        this.verifyCreateThreeColTwoPk("CREATE TABLE \"myTable\" (" + System.lineSeparator() + "\"pk1\" INTEGER NOT NULL," + System.lineSeparator() + "\"pk2\" INTEGER NOT NULL," + System.lineSeparator() + "\"col1\" INTEGER NOT NULL," + System.lineSeparator() + "PRIMARY KEY(\"pk1\",\"pk2\"))");
    }

    @Test
    public void alterAddOneCol() {
        this.verifyAlterAddOneCol("ALTER TABLE \"myTable\" ADD \"newcol1\" INTEGER NULL");
    }

    @Test
    public void alterAddTwoCol() {
        this.verifyAlterAddTwoCols("ALTER TABLE \"myTable\" " + System.lineSeparator() + "ADD \"newcol1\" INTEGER NULL," + System.lineSeparator() + "ADD \"newcol2\" INTEGER DEFAULT 42");
    }

    @Test
    public void insert() {
        TableId customers = this.tableId("customers");
        String expected = "INSERT INTO \"customers\"(\"age\",\"firstName\",\"lastName\") VALUES(?,?,?)";
        String sql = ((DerbyDatabaseDialect)this.dialect).buildInsertStatement(customers, this.columns(customers, new String[0]), this.columns(customers, "age", "firstName", "lastName"));
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void update() {
        TableId customers = this.tableId("customers");
        String expected = "UPDATE \"customers\" SET \"age\" = ?, \"firstName\" = ?, \"lastName\" = ? WHERE \"id\" = ?";
        String sql = ((DerbyDatabaseDialect)this.dialect).buildUpdateStatement(customers, this.columns(customers, "id"), this.columns(customers, "age", "firstName", "lastName"));
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Ignore
    @Test
    public void shouldBuildUpsertStatement() {
        String expected = "merge into \"myTable\" using (values(?, ?, ?, ?, ?, ?)) as DAT(\"id1\", \"id2\", \"columnA\", \"columnB\", \"columnC\", \"columnD\") on \"myTable\".\"id1\"=DAT.\"id1\" and \"myTable\".\"id2\"=DAT.\"id2\" when matched then update set \"myTable\".\"columnA\"=DAT.\"columnA\", set \"myTable\".\"columnB\"=DAT.\"columnB\", set \"myTable\".\"columnC\"=DAT.\"columnC\", set \"myTable\".\"columnD\"=DAT.\"columnD\" when not matched then insert(\"myTable\".\"columnA\",\"myTable\".\"columnB\",\"myTable\".\"columnC\",\"myTable\".\"columnD\",\"myTable\".\"id1\",\"myTable\".\"id2\") values(DAT.\"columnA\",DAT.\"columnB\",DAT.\"columnC\",DAT.\"columnD\",DAT.\"id1\",DAT.\"id2\")";
        String sql = ((DerbyDatabaseDialect)this.dialect).buildUpsertQueryStatement(this.tableId, (Collection)this.pkColumns, (Collection)this.columnsAtoD);
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Ignore
    @Test
    public void upsert() {
        TableId actor = this.tableId("actor");
        String expected = "merge into \"actor\" using (values(?, ?, ?, ?)) as DAT(\"actor_id\", \"first_name\", \"last_name\", \"score\") on \"actor\".\"actor_id\"=DAT.\"actor_id\" when matched then update set \"actor\".\"first_name\"=DAT.\"first_name\", set \"actor\".\"last_name\"=DAT.\"last_name\", set \"actor\".\"score\"=DAT.\"score\" when not matched then insert(\"actor\".\"first_name\",\"actor\".\"last_name\",\"actor\".\"score\",\"actor\".\"actor_id\") values(DAT.\"first_name\",DAT.\"last_name\",DAT.\"score\",DAT.\"actor_id\")";
        String sql = ((DerbyDatabaseDialect)this.dialect).buildUpsertQueryStatement(actor, this.columns(actor, "actor_id"), this.columns(actor, "first_name", "last_name", "score"));
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void upsertOnlyKeyCols() {
        TableId actor = this.tableId("actor");
        String expected = "merge into \"actor\" using (values(?)) as DAT(\"actor_id\") on \"actor\".\"actor_id\"=DAT.\"actor_id\" when not matched then insert(\"actor\".\"actor_id\") values(DAT.\"actor_id\")";
        String sql = ((DerbyDatabaseDialect)this.dialect).buildUpsertQueryStatement(actor, this.columns(actor, "actor_id"), this.columns(actor, new String[0]));
        Assert.assertEquals((Object)expected, (Object)sql);
    }
}

