/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.DatabaseDialects;
import io.confluent.connect.jdbc.dialect.DerbyDatabaseDialect;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.dialect.MockDatabaseDialect;
import io.confluent.connect.jdbc.dialect.MySqlDatabaseDialect;
import io.confluent.connect.jdbc.dialect.OracleDatabaseDialect;
import io.confluent.connect.jdbc.dialect.PostgreSqlDatabaseDialect;
import io.confluent.connect.jdbc.dialect.SapHanaDatabaseDialect;
import io.confluent.connect.jdbc.dialect.SqlServerDatabaseDialect;
import io.confluent.connect.jdbc.dialect.SqliteDatabaseDialect;
import io.confluent.connect.jdbc.dialect.VerticaDatabaseDialect;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Assert;
import org.junit.Test;

public class DatabaseDialectsTest {
    @Test
    public void shouldLoadAllBuiltInDialects() {
        Collection providers = DatabaseDialects.registeredDialectProviders();
        this.assertContainsInstanceOf(providers, GenericDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, DerbyDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, OracleDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, SqliteDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, PostgreSqlDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, MySqlDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, SqlServerDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, SapHanaDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, VerticaDatabaseDialect.Provider.class);
        this.assertContainsInstanceOf(providers, MockDatabaseDialect.Provider.class);
    }

    @Test
    public void shouldFindGenericDialect() {
        this.assertDialect(GenericDatabaseDialect.class, "jdbc:someting:");
    }

    @Test
    public void shouldFindDerbyDialect() {
        this.assertDialect(DerbyDatabaseDialect.class, "jdbc:derby:sample");
    }

    @Test
    public void shouldFindOracleDialect() {
        this.assertDialect(OracleDatabaseDialect.class, "jdbc:oracle:thin:@something");
        this.assertDialect(OracleDatabaseDialect.class, "jdbc:oracle:doesn'tmatter");
    }

    @Test
    public void shouldFindSqliteDialect() {
        this.assertDialect(SqliteDatabaseDialect.class, "jdbc:sqlite:C:/sqlite/db/chinook.db");
    }

    @Test
    public void shouldFindPostgreSqlDialect() {
        this.assertDialect(PostgreSqlDatabaseDialect.class, "jdbc:postgresql://localhost/test");
    }

    @Test
    public void shouldFindMySqlDialect() {
        this.assertDialect(MySqlDatabaseDialect.class, "jdbc:mysql://localhost:3306/sakila?profileSQL=true");
    }

    @Test
    public void shouldFindSqlServerDialect() {
        this.assertDialect(SqlServerDatabaseDialect.class, "jdbc:sqlserver://localhost;user=Me");
        this.assertDialect(SqlServerDatabaseDialect.class, "jdbc:microsoft:sqlserver://localhost;user=Me");
        this.assertDialect(SqlServerDatabaseDialect.class, "jdbc:jtds:sqlserver://localhost;user=Me");
    }

    @Test
    public void shouldFindSapDialect() {
        this.assertDialect(SapHanaDatabaseDialect.class, "jdbc:sap://myServer:30015/?autocommit=false");
    }

    @Test
    public void shouldFindVerticaDialect() {
        this.assertDialect(VerticaDatabaseDialect.class, "jdbc:vertica://VerticaHost:portNumber/databaseName");
    }

    @Test
    public void shouldFindMockDialect() {
        this.assertDialect(MockDatabaseDialect.class, "jdbc:mock:argle");
    }

    @Test(expected=ConnectException.class)
    public void shouldNotFindDialectForInvalidUrl() {
        DatabaseDialects.extractJdbcUrlInfo((String)"jdbc:protocolinvalid;field=value;");
    }

    @Test(expected=ConnectException.class)
    public void shouldNotFindDialectForInvalidUrlMissingJdbcPrefix() {
        DatabaseDialects.extractJdbcUrlInfo((String)"mysql://Server:port");
    }

    private void assertDialect(Class<? extends DatabaseDialect> clazz, String url) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("connection.url", url);
        props.put("topic.prefix", "prefix");
        props.put("mode", "bulk");
        JdbcSourceConnectorConfig config = new JdbcSourceConnectorConfig(props);
        DatabaseDialect dialect = DatabaseDialects.findBestFor((String)url, (AbstractConfig)config);
        TestCase.assertSame(dialect.getClass(), clazz);
    }

    private void assertContainsInstanceOf(Collection<? extends DatabaseDialectProvider> providers, Class<? extends DatabaseDialectProvider> clazz) {
        for (DatabaseDialectProvider databaseDialectProvider : providers) {
            if (!databaseDialectProvider.getClass().equals(clazz)) continue;
            return;
        }
        Assert.fail((String)("Missing " + clazz.getName()));
    }
}

