/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.source.ColumnMapping;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.TableId;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class BaseDialectTypeTest<T extends GenericDatabaseDialect> {
    public static final boolean NULLABLE = true;
    public static final boolean NOT_NULLABLE = false;
    public static final TableId TABLE_ID = new TableId(null, null, "MyTable");
    public static final ColumnId COLUMN_ID = new ColumnId(TABLE_ID, "columnA", "aliasA");
    public static final BigDecimal BIG_DECIMAL = new BigDecimal(9.9);
    public static final long LONG = Long.MAX_VALUE;
    public static final int INT = Integer.MAX_VALUE;
    public static final short SHORT = Short.MAX_VALUE;
    public static final byte BYTE = 127;
    public static final double DOUBLE = Double.MAX_VALUE;
    @Parameterized.Parameter(value=0)
    public Schema.Type expectedType;
    @Parameterized.Parameter(value=1)
    public Object expectedValue;
    @Parameterized.Parameter(value=2)
    public JdbcSourceConnectorConfig.NumericMapping numMapping;
    @Parameterized.Parameter(value=3)
    public boolean optional;
    @Parameterized.Parameter(value=4)
    public int columnType;
    @Parameterized.Parameter(value=5)
    public int precision;
    @Parameterized.Parameter(value=6)
    public int scale;
    @Mock
    ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
    @Mock
    ColumnDefinition columnDefn = (ColumnDefinition)Mockito.mock(ColumnDefinition.class);
    protected boolean signed = true;
    protected T dialect;
    protected SchemaBuilder schemaBuilder;
    protected DatabaseDialect.ColumnConverter converter;

    @Before
    public void setup() throws Exception {
        this.dialect = this.createDialect();
    }

    @Test
    public void testValueConversionOnNumeric() throws Exception {
        Mockito.when((Object)this.columnDefn.precision()).thenReturn((Object)this.precision);
        Mockito.when((Object)this.columnDefn.scale()).thenReturn((Object)this.scale);
        Mockito.when((Object)this.columnDefn.type()).thenReturn((Object)this.columnType);
        Mockito.when((Object)this.columnDefn.isOptional()).thenReturn((Object)this.optional);
        Mockito.when((Object)this.columnDefn.id()).thenReturn((Object)COLUMN_ID);
        Mockito.when((Object)this.columnDefn.isSignedNumber()).thenReturn((Object)this.signed);
        Mockito.when((Object)this.columnDefn.typeName()).thenReturn((Object)"parameterizedType");
        this.dialect = this.createDialect();
        this.schemaBuilder = SchemaBuilder.struct();
        this.dialect.addFieldToSchema(this.columnDefn, this.schemaBuilder);
        Schema schema = this.schemaBuilder.build();
        List fields = schema.fields();
        Assert.assertEquals((long)1L, (long)fields.size());
        Field field = (Field)fields.get(0);
        Assert.assertEquals((Object)this.expectedType, (Object)field.schema().type());
        Mockito.when((Object)this.resultSet.getBigDecimal(1, this.scale)).thenReturn((Object)BIG_DECIMAL);
        Mockito.when((Object)this.resultSet.getBigDecimal(1, -this.scale)).thenReturn((Object)BIG_DECIMAL);
        Mockito.when((Object)this.resultSet.getBigDecimal(1)).thenReturn((Object)BIG_DECIMAL);
        Mockito.when((Object)this.resultSet.getLong(1)).thenReturn((Object)Long.MAX_VALUE);
        Mockito.when((Object)this.resultSet.getInt(1)).thenReturn((Object)Integer.MAX_VALUE);
        Mockito.when((Object)this.resultSet.getShort(1)).thenReturn((Object)Short.MAX_VALUE);
        Mockito.when((Object)this.resultSet.getByte(1)).thenReturn((Object)127);
        Mockito.when((Object)this.resultSet.getDouble(1)).thenReturn((Object)Double.MAX_VALUE);
        ColumnMapping mapping = new ColumnMapping(this.columnDefn, 1, field);
        this.converter = this.dialect.columnConverterFor(mapping, mapping.columnDefn(), mapping.columnNumber(), true);
        Object value = this.converter.convert(this.resultSet);
        if (value instanceof Number && this.expectedValue instanceof Number) {
            Assert.assertEquals((double)((Number)this.expectedValue).floatValue(), (double)((Number)value).floatValue(), (double)0.01);
        } else {
            Assert.assertEquals((Object)this.expectedValue, (Object)value);
        }
    }

    protected abstract T createDialect();

    protected JdbcSourceConnectorConfig sourceConfigWithUrl(String url, String ... propertyPairs) {
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.put("mode", "bulk");
        connProps.put("topic.prefix", "test-");
        connProps.putAll(this.propertiesFromPairs(propertyPairs));
        connProps.put("connection.url", url);
        connProps.put("numeric.mapping", this.numMapping.toString());
        return new JdbcSourceConnectorConfig(connProps);
    }

    protected Map<String, String> propertiesFromPairs(String ... pairs) {
        HashMap<String, String> props = new HashMap<String, String>();
        Assert.assertEquals((String)("Expecting even number of properties but found " + pairs.length), (long)0L, (long)(pairs.length % 2));
        for (int i = 0; i != pairs.length; ++i) {
            String key = pairs[i];
            String value = pairs[++i];
            props.put(key, value);
        }
        return props;
    }
}

