/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.DateTimeUtils;
import io.confluent.connect.jdbc.util.TableId;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class BaseDialectTest<T extends GenericDatabaseDialect> {
    protected static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_DAYS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    protected static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_MILLIS;
    protected static final GregorianCalendar MARCH_15_2001_MIDNIGHT;
    protected TableId tableId;
    protected ColumnId columnPK1;
    protected ColumnId columnPK2;
    protected ColumnId columnA;
    protected ColumnId columnB;
    protected ColumnId columnC;
    protected ColumnId columnD;
    protected List<ColumnId> pkColumns;
    protected List<ColumnId> columnsAtoD;
    protected List<SinkRecordField> sinkRecordFields;
    protected T dialect;

    @Before
    public void setup() throws Exception {
        this.dialect = this.createDialect();
        Schema optionalDateWithDefault = org.apache.kafka.connect.data.Date.builder().defaultValue((Object)MARCH_15_2001_MIDNIGHT.getTime()).optional().build();
        Schema optionalTimeWithDefault = Time.builder().defaultValue((Object)MARCH_15_2001_MIDNIGHT.getTime()).optional().build();
        Schema optionalTsWithDefault = org.apache.kafka.connect.data.Timestamp.builder().defaultValue((Object)MARCH_15_2001_MIDNIGHT.getTime()).optional().build();
        Schema optionalDecimal = Decimal.builder((int)4).optional().parameter("p1", "v1").parameter("p2", "v2").build();
        this.tableId = new TableId(null, null, "myTable");
        this.columnPK1 = new ColumnId(this.tableId, "id1");
        this.columnPK2 = new ColumnId(this.tableId, "id2");
        this.columnA = new ColumnId(this.tableId, "columnA");
        this.columnB = new ColumnId(this.tableId, "columnB");
        this.columnC = new ColumnId(this.tableId, "columnC");
        this.columnD = new ColumnId(this.tableId, "columnD");
        this.pkColumns = Arrays.asList(this.columnPK1, this.columnPK2);
        this.columnsAtoD = Arrays.asList(this.columnA, this.columnB, this.columnC, this.columnD);
        SinkRecordField f1 = new SinkRecordField(Schema.INT32_SCHEMA, "c1", true);
        SinkRecordField f2 = new SinkRecordField(Schema.INT64_SCHEMA, "c2", false);
        SinkRecordField f3 = new SinkRecordField(Schema.STRING_SCHEMA, "c3", false);
        SinkRecordField f4 = new SinkRecordField(Schema.OPTIONAL_STRING_SCHEMA, "c4", false);
        SinkRecordField f5 = new SinkRecordField(optionalDateWithDefault, "c5", false);
        SinkRecordField f6 = new SinkRecordField(optionalTimeWithDefault, "c6", false);
        SinkRecordField f7 = new SinkRecordField(optionalTsWithDefault, "c7", false);
        SinkRecordField f8 = new SinkRecordField(optionalDecimal, "c8", false);
        this.sinkRecordFields = Arrays.asList(f1, f2, f3, f4, f5, f6, f7, f8);
    }

    protected abstract T createDialect();

    protected JdbcSourceConnectorConfig sourceConfigWithUrl(String url, String ... propertyPairs) {
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.put("mode", "bulk");
        connProps.put("topic.prefix", "test-");
        connProps.putAll(this.propertiesFromPairs(propertyPairs));
        connProps.put("connection.url", url);
        return new JdbcSourceConnectorConfig(connProps);
    }

    protected JdbcSinkConfig sinkConfigWithUrl(String url, String ... propertyPairs) {
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.putAll(this.propertiesFromPairs(propertyPairs));
        connProps.put("connection.url", url);
        return new JdbcSinkConfig(connProps);
    }

    protected void assertDecimalMapping(int scale, String expectedSqlType) {
        this.assertMapping(expectedSqlType, Decimal.schema((int)scale));
    }

    protected void assertDateMapping(String expectedSqlType) {
        this.assertMapping(expectedSqlType, org.apache.kafka.connect.data.Date.SCHEMA);
    }

    protected void assertTimeMapping(String expectedSqlType) {
        this.assertMapping(expectedSqlType, Time.SCHEMA);
    }

    protected void assertTimestampMapping(String expectedSqlType) {
        this.assertMapping(expectedSqlType, org.apache.kafka.connect.data.Timestamp.SCHEMA);
    }

    protected void assertPrimitiveMapping(Schema.Type type, String expectedSqlType) {
        this.assertMapping(expectedSqlType, type, null, new String[0]);
    }

    protected void assertMapping(String expectedSqlType, Schema schema) {
        this.assertMapping(expectedSqlType, schema.type(), schema.name(), schema.parameters());
    }

    protected void assertMapping(String expectedSqlType, Schema.Type type, String schemaName, Map<String, String> schemaParams) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(type).name(schemaName);
        if (schemaParams != null) {
            for (Map.Entry<String, String> entry : schemaParams.entrySet()) {
                schemaBuilder.parameter(entry.getKey(), entry.getValue());
            }
        }
        SinkRecordField field = new SinkRecordField(schemaBuilder.build(), schemaName, false);
        String sqlType = this.dialect.getSqlType(field);
        Assert.assertEquals((Object)expectedSqlType, (Object)sqlType);
    }

    protected void assertMapping(String expectedSqlType, Schema.Type type, String schemaName, String ... schemaParamPairs) {
        Map<String, String> schemaProps = this.propertiesFromPairs(schemaParamPairs);
        this.assertMapping(expectedSqlType, type, schemaName, schemaProps);
    }

    protected Map<String, String> propertiesFromPairs(String ... pairs) {
        HashMap<String, String> props = new HashMap<String, String>();
        Assert.assertEquals((String)("Expecting even number of properties but found " + pairs.length), (long)0L, (long)(pairs.length % 2));
        for (int i = 0; i != pairs.length; ++i) {
            String key = pairs[i];
            String value = pairs[++i];
            props.put(key, value);
        }
        return props;
    }

    protected void assertStatements(String[] expected, List<String> actual) {
        System.out.println(actual);
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i != expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual.get(i));
        }
    }

    protected TableId tableId(String name) {
        return new TableId(null, null, name);
    }

    protected Collection<ColumnId> columns(TableId id, String ... names) {
        ArrayList<ColumnId> columns = new ArrayList<ColumnId>();
        for (int i = 0; i != names.length; ++i) {
            columns.add(new ColumnId(id, names[i]));
        }
        return columns;
    }

    protected void verifyDataTypeMapping(String expected, Schema schema) {
        SinkRecordField field = new SinkRecordField(schema, schema.name(), schema.isOptional());
        Assert.assertEquals((Object)expected, (Object)this.dialect.getSqlType(field));
    }

    protected void verifyCreateOneColNoPk(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.dialect.buildCreateTableStatement(this.tableId, Arrays.asList(new SinkRecordField(Schema.INT32_SCHEMA, "col1", false))));
    }

    protected void verifyCreateOneColOnePk(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.dialect.buildCreateTableStatement(this.tableId, Arrays.asList(new SinkRecordField(Schema.INT32_SCHEMA, "pk1", true))));
    }

    protected void verifyCreateThreeColTwoPk(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.dialect.buildCreateTableStatement(this.tableId, Arrays.asList(new SinkRecordField(Schema.INT32_SCHEMA, "pk1", true), new SinkRecordField(Schema.INT32_SCHEMA, "pk2", true), new SinkRecordField(Schema.INT32_SCHEMA, "col1", false))));
    }

    protected void verifyAlterAddOneCol(String ... expected) {
        Assert.assertArrayEquals((Object[])expected, (Object[])this.dialect.buildAlterTable(this.tableId, Arrays.asList(new SinkRecordField(Schema.OPTIONAL_INT32_SCHEMA, "newcol1", false))).toArray());
    }

    protected void verifyAlterAddTwoCols(String ... expected) {
        Assert.assertArrayEquals((Object[])expected, (Object[])this.dialect.buildAlterTable(this.tableId, Arrays.asList(new SinkRecordField(Schema.OPTIONAL_INT32_SCHEMA, "newcol1", false), new SinkRecordField(SchemaBuilder.int32().defaultValue((Object)42).build(), "newcol2", false))).toArray());
    }

    @Test
    public void bindFieldPrimitiveValues() throws SQLException {
        int index = ThreadLocalRandom.current().nextInt();
        this.verifyBindField(++index, Schema.INT8_SCHEMA, (byte)42).setByte(index, (byte)42);
        this.verifyBindField(++index, Schema.INT16_SCHEMA, (short)42).setShort(index, (short)42);
        this.verifyBindField(++index, Schema.INT32_SCHEMA, 42).setInt(index, 42);
        this.verifyBindField(++index, Schema.INT64_SCHEMA, 42L).setLong(index, 42L);
        this.verifyBindField(++index, Schema.BOOLEAN_SCHEMA, false).setBoolean(index, false);
        this.verifyBindField(++index, Schema.BOOLEAN_SCHEMA, true).setBoolean(index, true);
        this.verifyBindField(++index, Schema.FLOAT32_SCHEMA, Float.valueOf(-42.0f)).setFloat(index, -42.0f);
        this.verifyBindField(++index, Schema.FLOAT64_SCHEMA, 42.0).setDouble(index, 42.0);
        this.verifyBindField(++index, Schema.BYTES_SCHEMA, new byte[]{42}).setBytes(index, new byte[]{42});
        this.verifyBindField(++index, Schema.BYTES_SCHEMA, ByteBuffer.wrap(new byte[]{42})).setBytes(index, new byte[]{42});
        this.verifyBindField(++index, Schema.STRING_SCHEMA, "yep").setString(index, "yep");
        this.verifyBindField(++index, Decimal.schema((int)0), new BigDecimal("1.5").setScale(0, 6)).setBigDecimal(index, new BigDecimal(2));
        this.verifyBindField(++index, org.apache.kafka.connect.data.Date.SCHEMA, new java.util.Date(0L)).setDate(index, new Date(0L), (Calendar)DateTimeUtils.UTC_CALENDAR.get());
        this.verifyBindField(++index, Time.SCHEMA, new java.util.Date(1000L)).setTime(index, new java.sql.Time(1000L), (Calendar)DateTimeUtils.UTC_CALENDAR.get());
        this.verifyBindField(++index, org.apache.kafka.connect.data.Timestamp.SCHEMA, new java.util.Date(100L)).setTimestamp(index, new Timestamp(100L), (Calendar)DateTimeUtils.UTC_CALENDAR.get());
    }

    @Test
    public void bindFieldNull() throws SQLException {
        List<Schema> nullableTypes = Arrays.asList(Schema.INT8_SCHEMA, Schema.INT16_SCHEMA, Schema.INT32_SCHEMA, Schema.INT64_SCHEMA, Schema.FLOAT32_SCHEMA, Schema.FLOAT64_SCHEMA, Schema.BOOLEAN_SCHEMA, Schema.BYTES_SCHEMA, Schema.STRING_SCHEMA, Decimal.schema((int)0), org.apache.kafka.connect.data.Date.SCHEMA, Time.SCHEMA, org.apache.kafka.connect.data.Timestamp.SCHEMA);
        int index = 0;
        for (Schema schema : nullableTypes) {
            this.verifyBindField(++index, schema, null).setObject(index, null);
        }
    }

    @Test(expected=ConnectException.class)
    public void bindFieldStructUnsupported() throws SQLException {
        Schema structSchema = SchemaBuilder.struct().field("test", Schema.BOOLEAN_SCHEMA).build();
        this.dialect.bindField((PreparedStatement)Mockito.mock(PreparedStatement.class), 1, structSchema, (Object)new Struct(structSchema));
    }

    @Test(expected=ConnectException.class)
    public void bindFieldArrayUnsupported() throws SQLException {
        SchemaBuilder arraySchema = SchemaBuilder.array((Schema)Schema.INT8_SCHEMA);
        this.dialect.bindField((PreparedStatement)Mockito.mock(PreparedStatement.class), 1, (Schema)arraySchema, Collections.emptyList());
    }

    @Test(expected=ConnectException.class)
    public void bindFieldMapUnsupported() throws SQLException {
        SchemaBuilder mapSchema = SchemaBuilder.map((Schema)Schema.INT8_SCHEMA, (Schema)Schema.INT8_SCHEMA);
        this.dialect.bindField((PreparedStatement)Mockito.mock(PreparedStatement.class), 1, (Schema)mapSchema, Collections.emptyMap());
    }

    protected PreparedStatement verifyBindField(int index, Schema schema, Object value) throws SQLException {
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.dialect.bindField(statement, index, schema, value);
        return (PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1));
    }

    static {
        EPOCH_PLUS_TEN_THOUSAND_DAYS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_DAYS.add(5, 10000);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.add(14, 10000);
        MARCH_15_2001_MIDNIGHT = new GregorianCalendar(2001, 2, 15, 0, 0, 0);
        MARCH_15_2001_MIDNIGHT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

