/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc;

import io.confluent.connect.jdbc.JdbcSourceConnector;
import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.EmbeddedDerby;
import io.confluent.connect.jdbc.source.JdbcSourceTask;
import io.confluent.connect.jdbc.util.CachedConnectionProvider;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;
import org.easymock.EasyMock;
import org.easymock.Mock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JdbcSourceConnector.class, DatabaseDialect.class})
@PowerMockIgnore(value={"javax.management.*"})
public class JdbcSourceConnectorTest {
    private JdbcSourceConnector connector;
    private EmbeddedDerby db;
    private Map<String, String> connProps;
    @Mock
    private DatabaseDialect dialect;

    @Before
    public void setup() {
        this.connector = new JdbcSourceConnector();
        this.db = new EmbeddedDerby();
        this.connProps = new HashMap<String, String>();
        this.connProps.put("connection.url", this.db.getUrl());
        this.connProps.put("mode", "bulk");
        this.connProps.put("topic.prefix", "test-");
    }

    @After
    public void tearDown() throws Exception {
        this.db.close();
        this.db.dropDatabase();
    }

    @Test
    public void testTaskClass() {
        Assert.assertEquals(JdbcSourceTask.class, (Object)this.connector.taskClass());
    }

    @Test(expected=ConnectException.class)
    public void testMissingUrlConfig() throws Exception {
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.put("mode", "bulk");
        this.connector.start(connProps);
    }

    @Test(expected=ConnectException.class)
    public void testMissingModeConfig() throws Exception {
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.put("connection.url", this.db.getUrl());
        this.connector.start(Collections.emptyMap());
    }

    @Test(expected=ConnectException.class)
    public void testStartConnectionFailure() throws Exception {
        this.connector.start(Collections.singletonMap("connection.url", "jdbc:foo"));
    }

    @Test
    public void testStartStop() throws Exception {
        CachedConnectionProvider mockCachedConnectionProvider = (CachedConnectionProvider)PowerMock.createMock(CachedConnectionProvider.class);
        PowerMock.expectNew(CachedConnectionProvider.class, (Object[])new Object[]{EasyMock.anyObject(DatabaseDialect.class), EasyMock.eq((int)3), EasyMock.eq((long)10000L)}).andReturn((Object)mockCachedConnectionProvider);
        Connection conn = (Connection)PowerMock.createMock(Connection.class);
        EasyMock.expect((Object)mockCachedConnectionProvider.getConnection()).andReturn((Object)conn).anyTimes();
        EasyMock.expect((Object)conn.getMetaData()).andStubThrow((Throwable)new SQLException());
        mockCachedConnectionProvider.close();
        PowerMock.expectLastCall().atLeastOnce();
        PowerMock.replayAll((Object[])new Object[0]);
        this.connector.start(this.connProps);
        this.connector.stop();
        PowerMock.verifyAll();
    }

    @Test
    public void testPartitioningOneTable() throws Exception {
        this.db.createTable("test", "id", "INT NOT NULL");
        this.connector.start(this.connProps);
        List configs = this.connector.taskConfigs(10);
        Assert.assertEquals((long)1L, (long)configs.size());
        this.assertTaskConfigsHaveParentConfigs(configs);
        Assert.assertEquals((Object)this.tables("test"), ((Map)configs.get(0)).get("tables"));
        Assert.assertNull(((Map)configs.get(0)).get("query"));
        this.connector.stop();
    }

    @Test
    public void testPartitioningManyTables() throws Exception {
        this.db.createTable("test1", "id", "INT NOT NULL");
        this.db.createTable("test2", "id", "INT NOT NULL");
        this.db.createTable("test3", "id", "INT NOT NULL");
        this.db.createTable("test4", "id", "INT NOT NULL");
        this.connector.start(this.connProps);
        List configs = this.connector.taskConfigs(3);
        Assert.assertEquals((long)3L, (long)configs.size());
        this.assertTaskConfigsHaveParentConfigs(configs);
        Assert.assertEquals((Object)this.tables("test1", "test2"), ((Map)configs.get(0)).get("tables"));
        Assert.assertNull(((Map)configs.get(0)).get("query"));
        Assert.assertEquals((Object)this.tables("test3"), ((Map)configs.get(1)).get("tables"));
        Assert.assertNull(((Map)configs.get(1)).get("query"));
        Assert.assertEquals((Object)this.tables("test4"), ((Map)configs.get(2)).get("tables"));
        Assert.assertNull(((Map)configs.get(2)).get("query"));
        this.connector.stop();
    }

    @Test
    public void testPartitioningQuery() throws Exception {
        this.db.createTable("test1", "id", "INT NOT NULL");
        this.db.createTable("test2", "id", "INT NOT NULL");
        String sample_query = "SELECT foo, bar FROM sample_table";
        this.connProps.put("query", "SELECT foo, bar FROM sample_table");
        this.connector.start(this.connProps);
        List configs = this.connector.taskConfigs(3);
        Assert.assertEquals((long)1L, (long)configs.size());
        this.assertTaskConfigsHaveParentConfigs(configs);
        Assert.assertEquals((Object)"", ((Map)configs.get(0)).get("tables"));
        Assert.assertEquals((Object)"SELECT foo, bar FROM sample_table", ((Map)configs.get(0)).get("query"));
        this.connector.stop();
    }

    @Test(expected=ConnectException.class)
    public void testConflictingQueryTableSettings() {
        String sample_query = "SELECT foo, bar FROM sample_table";
        this.connProps.put("query", "SELECT foo, bar FROM sample_table");
        this.connProps.put("table.whitelist", "foo,bar");
        this.connector.start(this.connProps);
    }

    private void assertTaskConfigsHaveParentConfigs(List<Map<String, String>> configs) {
        for (Map<String, String> config : configs) {
            Assert.assertEquals((Object)this.db.getUrl(), (Object)config.get("connection.url"));
        }
    }

    private String tables(String ... names) {
        ArrayList<TableId> tableIds = new ArrayList<TableId>();
        for (String name : names) {
            tableIds.add(new TableId(null, "APP", name));
        }
        ExpressionBuilder builder = ExpressionBuilder.create();
        builder.appendList().delimitedBy(",").of(tableIds);
        return builder.toString();
    }
}

