/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.wal;

import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.hdfs.wal.FSWAL;
import io.confluent.connect.hdfs.wal.WAL;
import io.confluent.connect.storage.StorageFactory;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Assert;
import org.junit.Test;

public class WALTest
extends TestWithMiniDFSCluster {
    private static final String ZERO_PAD_FMT = "%010d";
    private HdfsStorage storage;
    private boolean closed;
    private static final String extension = ".avro";

    @Test
    public void testMultiWALFromOneDFSClient() throws Exception {
        this.setUp();
        String topicsDir = (String)this.topicsDir.get(TOPIC_PARTITION.topic());
        fs.delete(new Path(FileUtils.directoryName((String)this.url, (String)topicsDir, (TopicPartition)TOPIC_PARTITION)), true);
        Class storageClass = this.connectorConfig.getClass("storage.class");
        this.storage = (HdfsStorage)StorageFactory.createStorage((Class)storageClass, HdfsSinkConnectorConfig.class, (Object)this.connectorConfig, (String)this.url);
        WAL wal1 = this.storage.wal(topicsDir, TOPIC_PARTITION);
        FSWAL wal2 = (FSWAL)this.storage.wal(topicsDir, TOPIC_PARTITION);
        String directory = "test-topic/" + String.valueOf(12);
        String tempfile = FileUtils.tempFileName((String)this.url, (String)topicsDir, (String)directory, (String)extension);
        String committedFile = FileUtils.committedFileName((String)this.url, (String)topicsDir, (String)directory, (TopicPartition)TOPIC_PARTITION, (long)0L, (long)10L, (String)extension, (String)ZERO_PAD_FMT);
        fs.createNewFile(new Path(tempfile));
        wal1.acquireLease();
        wal1.append("BEGIN", "");
        wal1.append(tempfile, committedFile);
        wal1.append("END", "");
        Thread thread = new Thread(new Runnable((io.confluent.connect.storage.wal.WAL)wal1){
            final /* synthetic */ io.confluent.connect.storage.wal.WAL val$wal1;
            {
                this.val$wal1 = wAL;
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(900L);
                    WALTest.this.closed = true;
                    this.val$wal1.close();
                }
                catch (InterruptedException | ConnectException throwable) {
                    // empty catch block
                }
            }
        });
        thread.start();
        wal2.acquireLease();
        Assert.assertTrue((boolean)this.closed);
        wal2.apply();
        wal2.close();
        Assert.assertTrue((boolean)fs.exists(new Path(committedFile)));
        Assert.assertFalse((boolean)fs.exists(new Path(tempfile)));
        this.storage.close();
    }
}

