/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.wal;

import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.hdfs.wal.FSWAL;
import io.confluent.connect.hdfs.wal.WAL;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Assert;
import org.junit.Test;

public class FSWALTest
extends TestWithMiniDFSCluster {
    @Test
    public void testTruncate() throws Exception {
        this.setUp();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        TopicPartition tp = new TopicPartition("mytopic", 123);
        FSWAL wal = new FSWAL("/logs", tp, storage);
        wal.append("a", "b");
        Assert.assertTrue((String)"WAL file should exist after append", (boolean)storage.exists("/logs/mytopic/123/log"));
        wal.truncate();
        Assert.assertFalse((String)"WAL file should not exist after truncate", (boolean)storage.exists("/logs/mytopic/123/log"));
        Assert.assertTrue((String)"Rotated WAL file should exist after truncate", (boolean)storage.exists("/logs/mytopic/123/log.1"));
        wal.append("c", "d");
        Assert.assertTrue((String)"WAL file should be recreated after truncate + append", (boolean)storage.exists("/logs/mytopic/123/log"));
        Assert.assertTrue((String)"Rotated WAL file should exist after truncate + append", (boolean)storage.exists("/logs/mytopic/123/log.1"));
    }

    @Test
    public void testEmptyWalFileRecovery() throws Exception {
        this.setUp();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        TopicPartition tp = new TopicPartition("mytopic", 123);
        fs.create(new Path(FileUtils.logFileName((String)this.url, (String)this.logsDir, (TopicPartition)tp)), true);
        FSWAL wal = new FSWAL("/logs", tp, storage);
        wal.acquireLease();
    }

    @Test
    public void testTruncatedVersionWalFileRecovery() throws Exception {
        this.setUp();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        TopicPartition tp = new TopicPartition("mytopic", 123);
        FSDataOutputStream o = fs.create(new Path(FileUtils.logFileName((String)this.url, (String)this.logsDir, (TopicPartition)tp)), true);
        o.write(47);
        o.write(61);
        FSWAL wal = new FSWAL("/logs", tp, storage);
        wal.acquireLease();
    }

    @Test
    public void testExtractOffsetsFromPath() {
        List<String> filepaths = Arrays.asList("hdfs://namenode:8020/topics/test_hdfs/f1=value1/test_hdfs+0+0000000000+0000000000.avro", "hdfs://namenode:8020/topics/test_hdfs/f1=value6/test_hdfs+0+0000000005+0000000005.avro", "hdfs://namenode:8020/topics/test_hdfs/f1=value1/test_hdfs+0+0000000006+0000000009.avro", "hdfs://namenode:8020/topics/test_hdfs/f1=value1/test_hdfs+0+0000001034+0000001333.avro", "hdfs://namenode:8020/topics/test_hdfs/f1=value1/test_hdfs+0+0123132133+0213314343.avro");
        long[] expectedOffsets = new long[]{0L, 5L, 9L, 1333L, 213314343L};
        int index = 0;
        for (String path : filepaths) {
            long extractedOffset = FSWAL.extractOffsetsFromFilePath((String)path);
            Assert.assertEquals((long)expectedOffsets[index], (long)extractedOffset);
            ++index;
        }
    }

    @Test
    public void testOffsetsExtractedFromWALWithEmptyBlocks() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        Assert.assertNull((Object)wal.extractLatestOffset());
        this.addSampleEntriesToWAL((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        long latestOffset = wal.extractLatestOffset().getOffset();
        Assert.assertEquals((long)49L, (long)latestOffset);
    }

    @Test
    public void testNoOffsetsFromWALWithMissingEndMarkerFirstBlock() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        wal.append("BEGIN", "");
        this.addSampleEntriesToWALNoMarkers((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("END", "");
        wal.close();
        Assert.assertNull((Object)wal.extractLatestOffset());
    }

    @Test
    public void testNoOffsetsFromWALWithMissingEndMarkerMiddleBlock() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        this.addSampleEntriesToWALNoMarkers((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("END", "");
        wal.close();
        Assert.assertNull((Object)wal.extractLatestOffset());
    }

    @Test
    public void testOffsetsFromWALWithMissingEndMarkerLastBlockAndValidPreviousBlock() throws Exception {
        long expectedOffset = 108L;
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        wal.append("BEGIN", "");
        String tempfile = FileUtils.tempFileName((String)this.url, (String)((String)this.topicsDir.get(TOPIC_PARTITION.topic())), (String)this.getDirectory(), (String)this.extension);
        fs.createNewFile(new Path(tempfile));
        String committedFile = FileUtils.committedFileName((String)this.url, (String)((String)this.topicsDir.get(TOPIC_PARTITION.topic())), (String)this.getDirectory(), (TopicPartition)TOPIC_PARTITION, (long)9L, (long)expectedOffset, (String)this.extension, (String)this.zeroPadFormat);
        wal.append(tempfile, committedFile);
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        this.addSampleEntriesToWALNoMarkers((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.close();
        Assert.assertEquals((long)expectedOffset, (long)wal.extractLatestOffset().getOffset());
    }

    @Test
    public void testNoOffsetsFromWALWithMissingEndMarkerLastBlock() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        this.addSampleEntriesToWALNoMarkers((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        Assert.assertNull((Object)wal.extractLatestOffset());
    }

    @Test
    public void testNoOffsetsFromWALWithMissingBeginMarkerFirstBlock() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        this.addSampleEntriesToWALNoMarkers((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.append("END", "");
        wal.close();
        Assert.assertNull((Object)wal.extractLatestOffset());
    }

    @Test
    public void testNoOffsetsFromWALWithMissingBeginMarkerMiddleBlock() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        this.addSampleEntriesToWALNoMarkers((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.close();
        Assert.assertNull((Object)wal.extractLatestOffset());
    }

    @Test
    public void testNoOffsetsFromWALWithMissingBeginMarkerLastBlock() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        wal.append("BEGIN", "");
        wal.append("END", "");
        wal.append("BEGIN", "");
        wal.append("END", "");
        this.addSampleEntriesToWALNoMarkers((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.append("END", "");
        wal.close();
        Assert.assertNull((Object)wal.extractLatestOffset());
    }

    @Test
    public void testOffsetsExtractedFromWAL() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        this.addSampleEntriesToWAL((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        long latestOffset = wal.extractLatestOffset().getOffset();
        Assert.assertEquals((long)49L, (long)latestOffset);
    }

    @Test
    public void testOffsetsExtractedFromOldWAL() throws Exception {
        this.setupWalTest();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        FSWAL wal = (FSWAL)storage.wal(this.logsDir, TOPIC_PARTITION);
        this.addSampleEntriesToWAL((String)this.topicsDir.get(TOPIC_PARTITION.topic()), (WAL)wal, 5);
        wal.truncate();
        long latestOffset = wal.extractLatestOffset().getOffset();
        Assert.assertEquals((long)49L, (long)latestOffset);
    }

    private void setupWalTest() throws Exception {
        this.setUp();
        String topicsDir = (String)this.topicsDir.get(TOPIC_PARTITION.topic());
        fs.delete(new Path(FileUtils.directoryName((String)this.url, (String)topicsDir, (TopicPartition)TOPIC_PARTITION)), true);
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        this.partitioner = hdfsWriter.getPartitioner();
    }

    private void addSampleEntriesToWAL(String topicsDir, WAL wal, int numEntries) throws IOException {
        wal.append("BEGIN", "");
        this.addSampleEntriesToWALNoMarkers(topicsDir, wal, numEntries);
        wal.append("END", "");
        wal.close();
    }

    private void addSampleEntriesToWALNoMarkers(String topicsDir, WAL wal, int numEntries) throws IOException {
        for (int i = 0; i < numEntries; ++i) {
            long startOffset = i * 10;
            long endOffset = (i + 1) * 10 - 1;
            String tempfile = FileUtils.tempFileName((String)this.url, (String)topicsDir, (String)this.getDirectory(), (String)this.extension);
            fs.createNewFile(new Path(tempfile));
            String committedFile = FileUtils.committedFileName((String)this.url, (String)topicsDir, (String)this.getDirectory(), (TopicPartition)TOPIC_PARTITION, (long)startOffset, (long)endOffset, (String)this.extension, (String)this.zeroPadFormat);
            wal.append(tempfile, committedFile);
        }
    }

    @Test
    public void testApply() throws Exception {
        this.setUp();
        System.out.println("Testing testApply...");
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        TopicPartition tp = new TopicPartition("mytopic", 123);
        FSWAL wal = new FSWAL("/logs", tp, storage);
        wal.append("a", "b");
        Assert.assertTrue((String)"WAL file should exist after append", (boolean)storage.exists("/logs/mytopic/123/log"));
        wal.apply();
        wal.append("x", "y");
        wal.apply();
    }

    @Test
    public void testAcquireLeaseThrowsException() throws Exception {
        this.setUp();
        HdfsStorage storage = new HdfsStorage(this.connectorConfig, this.url);
        TopicPartition tp = new TopicPartition("mytopic", 123);
        cluster.shutdown(false, false);
        FSWAL wal = new FSWAL("/logs", tp, storage);
        int fileSystemCacheSizeBefore = this.getFileSystemCacheSize();
        for (int i = 0; i < 10; ++i) {
            try {
                wal.acquireLease();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)fileSystemCacheSizeBefore, (long)this.getFileSystemCacheSize());
    }
}

