/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.utils;

import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.utils.Data;
import io.confluent.connect.hdfs.utils.MemoryStorage;
import io.confluent.connect.hdfs.wal.WAL;
import io.confluent.connect.storage.wal.FilePathOffset;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;

public class MemoryWAL
implements WAL {
    private String logFile;
    private MemoryStorage storage;
    private static Map<String, List<Object>> data = Data.getData();

    public MemoryWAL(String topicsDir, TopicPartition topicPart, MemoryStorage storage) throws ConnectException {
        this.storage = storage;
        String url = storage.url();
        this.logFile = FileUtils.logFileName((String)url, (String)topicsDir, (TopicPartition)topicPart);
    }

    public void acquireLease() throws ConnectException {
    }

    public void append(String tempFile, String committedFile) throws ConnectException {
        LogEntry entry = new LogEntry(tempFile, committedFile);
        this.storage.append(this.logFile, entry);
    }

    public void apply() throws ConnectException {
        if (data.containsKey(this.logFile)) {
            List<Object> entryList = data.get(this.logFile);
            for (Object entry : entryList) {
                LogEntry logEntry = (LogEntry)entry;
                this.storage.commit(logEntry.key(), logEntry.value());
            }
        }
    }

    public void truncate() throws ConnectException {
        this.storage.commit(this.logFile, this.logFile + ".1");
        this.storage.delete(this.logFile);
    }

    public void close() throws ConnectException {
        this.storage.close();
    }

    public String getLogFile() {
        return this.logFile;
    }

    public FilePathOffset extractLatestOffset() {
        return null;
    }

    private static class LogEntry {
        private String key;
        private String value;

        public LogEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

