/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.utils;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.hdfs.utils.Data;
import io.confluent.connect.hdfs.utils.MemoryWAL;
import io.confluent.connect.hdfs.wal.WAL;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avro.file.SeekableInput;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;

public class MemoryStorage
extends HdfsStorage {
    private static final Map<String, List<Object>> data = Data.getData();
    private HdfsSinkConnectorConfig conf;
    private String url;
    private Failure failure = Failure.noFailure;

    public MemoryStorage(HdfsSinkConnectorConfig conf, String url) {
        super(conf, url, null);
        this.conf = conf;
        this.url = url;
    }

    public List<FileStatus> list(String path) {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (String key : data.keySet()) {
            if (!key.startsWith(path)) continue;
            FileStatus status = new FileStatus((long)data.get(key).size(), false, 1, 0L, 0L, 0L, null, null, null, new Path(key));
            result.add(status);
        }
        return result;
    }

    public List<FileStatus> list(String path, PathFilter filter) {
        if (this.failure == Failure.listStatusFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("listStatus failed.");
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (String key : data.keySet()) {
            if (!key.startsWith(path) || !filter.accept(new Path(key))) continue;
            FileStatus status = new FileStatus((long)data.get(key).size(), false, 1, 0L, 0L, 0L, null, null, null, new Path(key));
            result.add(status);
        }
        return result;
    }

    public void append(String filename, Object object) {
        if (this.failure == Failure.appendFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("append failed.");
        }
        if (!data.containsKey(filename)) {
            data.put(filename, new LinkedList());
        }
        data.get(filename).add(object);
    }

    public boolean create(String filename) {
        if (this.failure == Failure.mkdirsFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("mkdirs failed.");
        }
        return true;
    }

    public boolean exists(String filename) {
        if (this.failure == Failure.existsFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("exists failed.");
        }
        return data.containsKey(filename);
    }

    public void delete(String filename) {
        if (this.failure == Failure.deleteFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("delete failed.");
        }
        if (data.containsKey(filename)) {
            data.get(filename).clear();
            data.remove(filename);
        }
    }

    public void commit(String tempFile, String committedFile) {
        if (this.failure == Failure.commitFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("commit failed.");
        }
        if (!data.containsKey(committedFile)) {
            List<Object> entryList = data.get(tempFile);
            data.put(committedFile, entryList);
            data.remove(tempFile);
        }
    }

    public void close() {
        if (this.failure == Failure.closeFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("close failed.");
        }
        data.clear();
    }

    public WAL wal(String topicsDir, TopicPartition topicPart) {
        return new MemoryWAL(topicsDir, topicPart, this);
    }

    public HdfsSinkConnectorConfig conf() {
        return this.conf;
    }

    public String url() {
        return this.url;
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public SeekableInput open(String filename, HdfsSinkConnectorConfig conf) {
        return null;
    }

    public OutputStream create(String filename, HdfsSinkConnectorConfig conf, boolean overwrite) {
        return null;
    }

    public static enum Failure {
        noFailure,
        listStatusFailure,
        appendFailure,
        mkdirsFailure,
        existsFailure,
        deleteFailure,
        commitFailure,
        closeFailure;

    }
}

