/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.utils;

import io.confluent.connect.hdfs.utils.Data;
import io.confluent.connect.storage.format.RecordWriter;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

public class MemoryRecordWriter
implements RecordWriter {
    private String filename;
    private static final Map<String, List<Object>> data = Data.getData();
    private Failure failure = Failure.noFailure;

    public MemoryRecordWriter(String filename) {
        this.filename = filename;
    }

    public void write(SinkRecord record) {
        if (this.failure == Failure.writeFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("write failed.");
        }
        data.get(this.filename).add(record);
    }

    public void commit() {
    }

    public void close() {
        if (this.failure == Failure.closeFailure) {
            this.failure = Failure.noFailure;
            throw new ConnectException("close failed.");
        }
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public static enum Failure {
        noFailure,
        writeFailure,
        closeFailure;

    }
}

