/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.partitioner;

import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeUtils {
    public static String encodeTimestamp(long partitionDurationMs, String pathFormat, String timeZoneString, long timestamp) {
        DateTimeZone timeZone = DateTimeZone.forID((String)timeZoneString);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pathFormat).withZone(timeZone).withLocale(Locale.ENGLISH);
        DateTime partition = new DateTime(TimeUtils.getPartition(partitionDurationMs, timestamp, timeZone));
        return partition.toString(formatter);
    }

    private static long getPartition(long timeGranularityMs, long timestamp, DateTimeZone timeZone) {
        long adjustedTimeStamp = timeZone.convertUTCToLocal(timestamp);
        long partitionedTime = adjustedTimeStamp / timeGranularityMs * timeGranularityMs;
        return timeZone.convertLocalToUTC(partitionedTime, false);
    }
}

