/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.partitioner;

import io.confluent.connect.hdfs.HdfsSinkConnectorTestBase;
import io.confluent.connect.hdfs.partitioner.TimeBasedPartitioner;
import io.confluent.connect.hdfs.partitioner.TimeUtils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;

public class TimeBasedPartitionerTest
extends HdfsSinkConnectorTestBase {
    private static final String timeZoneString = "America/Los_Angeles";
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZone.forID((String)"America/Los_Angeles");

    @Test
    public void testGeneratePartitionedPath() throws Exception {
        this.setUp();
        BiHourlyPartitioner partitioner = new BiHourlyPartitioner();
        partitioner.configure(this.parsedConfig);
        String pathFormat = partitioner.getPathFormat();
        long partitionDurationMs = TimeUnit.HOURS.toMillis(2L);
        long timestamp = new DateTime(2015, 1, 1, 3, 0, 0, 0, DateTimeZone.forID((String)timeZoneString)).getMillis();
        String encodedPartition = TimeUtils.encodeTimestamp(partitionDurationMs, pathFormat, timeZoneString, timestamp);
        String path = partitioner.generatePartitionedPath("topic", encodedPartition);
        Assert.assertEquals((Object)"topic/year=2015/month=January/day=01/hour=2/", (Object)path);
    }

    @Test
    public void testDaylightSavingTime() {
        DateTime time = new DateTime(2015, 11, 1, 2, 1, DATE_TIME_ZONE);
        String pathFormat = "'year='YYYY/'month='MMMM/'day='dd/'hour='H/";
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pathFormat).withZone(DATE_TIME_ZONE);
        long utc1 = DATE_TIME_ZONE.convertLocalToUTC(time.getMillis() - TimeUnit.MINUTES.toMillis(60L), false);
        long utc2 = DATE_TIME_ZONE.convertLocalToUTC(time.getMillis() - TimeUnit.MINUTES.toMillis(120L), false);
        DateTime time1 = new DateTime(DATE_TIME_ZONE.convertUTCToLocal(utc1));
        DateTime time2 = new DateTime(DATE_TIME_ZONE.convertUTCToLocal(utc2));
        Assert.assertEquals((Object)time1.toString(formatter), (Object)time2.toString(formatter));
    }

    private static class BiHourlyPartitioner
    extends TimeBasedPartitioner {
        private static long partitionDurationMs = TimeUnit.HOURS.toMillis(2L);
        private static String pathFormat = "'year'=YYYY/'month'=MMMM/'day'=dd/'hour'=H/";

        private BiHourlyPartitioner() {
        }

        public void configure(Map<String, Object> config) {
            this.init(partitionDurationMs, pathFormat, Locale.FRENCH, DATE_TIME_ZONE, config);
        }

        public String getPathFormat() {
            return pathFormat;
        }
    }
}

