/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.partitioner;

import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.partitioner.DailyPartitioner;
import io.confluent.connect.hdfs.partitioner.TimeUtils;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DailyPartitionerTest
extends TestWithMiniDFSCluster {
    private static final long partitionDurationMs = TimeUnit.HOURS.toMillis(24L);

    @Test
    public void testDailyPartitioner() throws Exception {
        this.setUp();
        DailyPartitioner partitioner = new DailyPartitioner();
        partitioner.configure(this.parsedConfig);
        String pathFormat = partitioner.getPathFormat();
        String timeZoneString = (String)this.parsedConfig.get("timezone");
        long timestamp = new DateTime(2014, 2, 1, 3, 0, 0, 0, DateTimeZone.forID((String)timeZoneString)).getMillis();
        String encodedPartition = TimeUtils.encodeTimestamp(partitionDurationMs, pathFormat, timeZoneString, timestamp);
        String path = partitioner.generatePartitionedPath("topic", encodedPartition);
        Assert.assertEquals((Object)"topic/year=2014/month=02/day=01", (Object)path);
    }
}

