/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.parquet;

import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.hive.HiveTestBase;
import io.confluent.connect.hdfs.hive.HiveTestUtils;
import io.confluent.connect.hdfs.parquet.ParquetFormat;
import io.confluent.connect.hdfs.partitioner.DailyPartitioner;
import io.confluent.connect.hdfs.partitioner.FieldPartitioner;
import io.confluent.connect.hdfs.partitioner.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HiveIntegrationParquetTest
extends HiveTestBase {
    private final Map<String, String> localProps = new HashMap<String, String>();
    private final String hiveTableNameConfig;

    public HiveIntegrationParquetTest(String hiveTableNameConfig) {
        this.hiveTableNameConfig = hiveTableNameConfig;
    }

    @Parameterized.Parameters(name="{index}: hiveTableNameConfig={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"${topic}"}, {"a-${topic}-table"});
    }

    @Before
    public void beforeTest() {
        this.localProps.put("hive.table.name", this.hiveTableNameConfig);
    }

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.put("shutdown.timeout.ms", "10000");
        props.put("format.class", ParquetFormat.class.getName());
        props.putAll(this.localProps);
        return props;
    }

    @Test
    public void testSyncWithHiveParquet() throws Exception {
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.recover(TOPIC_PARTITION);
        List<SinkRecord> sinkRecords = this.createSinkRecords(7);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        this.localProps.put("hive.integration", "true");
        HdfsSinkConnectorConfig config = new HdfsSinkConnectorConfig(this.createProps());
        hdfsWriter = new DataWriter(config, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.syncWithHive();
        Schema schema = this.createSchema();
        Struct expectedRecord = this.createRecord(schema);
        ArrayList<String> expectedResult = new ArrayList<String>();
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Field field : schema.fields()) {
            expectedColumnNames.add(field.name());
            expectedResult.add(String.valueOf(expectedRecord.get(field.name())));
        }
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        List<String> expectedPartitions = Arrays.asList(this.partitionLocation("test-topic", 12));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
        hdfsWriter.close();
        hdfsWriter.stop();
    }

    @Test
    public void testHiveIntegrationParquet() throws Exception {
        this.localProps.put("hive.integration", "true");
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.recover(TOPIC_PARTITION);
        List<SinkRecord> sinkRecords = this.createSinkRecords(7);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        Schema schema = this.createSchema();
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Object field : schema.fields()) {
            expectedColumnNames.add(field.name());
        }
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        ArrayList<String> expectedPartitions = new ArrayList<String>();
        String directory = "test-topic/partition=" + String.valueOf(12);
        String topicsDir = (String)this.topicsDir.get(TOPIC_PARTITION.topic());
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)directory));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
    }

    @Test
    public void testHiveIntegrationFieldPartitionerParquet() throws Exception {
        int batchSize = 3;
        int batchNum = 3;
        this.localProps.put("hive.integration", "true");
        this.localProps.put("partitioner.class", FieldPartitioner.class.getName());
        this.localProps.put("partition.field.name", "int");
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        Schema schema = this.createSchema();
        List<Struct> records = this.createRecordBatches(schema, batchSize, batchNum);
        List<SinkRecord> sinkRecords = this.createSinkRecords(records, schema);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Object field : schema.fields()) {
            expectedColumnNames.add(field.name());
        }
        Collections.sort(expectedColumnNames);
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getAllCols()) {
            actualColumnNames.add(column.getName());
        }
        Collections.sort(actualColumnNames);
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        List partitionFieldNames = this.connectorConfig.getList("partition.field.name");
        String partitionFieldName = (String)partitionFieldNames.get(0);
        String directory1 = "test-topic/" + partitionFieldName + "=" + String.valueOf(16);
        String directory2 = "test-topic/" + partitionFieldName + "=" + String.valueOf(17);
        String directory3 = "test-topic/" + partitionFieldName + "=" + String.valueOf(18);
        String topicsDir = (String)this.topicsDir.get("test-topic");
        ArrayList<String> expectedPartitions = new ArrayList<String>();
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)directory1));
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)directory2));
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)directory3));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
        Struct sampleRecord = this.createRecord(schema, 16, 12.2f);
        ArrayList<ArrayList<String>> expectedResults = new ArrayList<ArrayList<String>>();
        for (int batch = 0; batch < batchNum; ++batch) {
            int intForBatch = sampleRecord.getInt32("int") + batch;
            float floatForBatch = sampleRecord.getFloat32("float").floatValue() + (float)batch;
            double doubleForBatch = sampleRecord.getFloat64("double") + (double)batch;
            for (int row = 0; row < batchSize; ++row) {
                ArrayList<String> result = new ArrayList<String>(Arrays.asList("true", String.valueOf(intForBatch), String.valueOf(floatForBatch), String.valueOf(doubleForBatch), String.valueOf(intForBatch)));
                expectedResults.add(result);
            }
        }
        String result = HiveTestUtils.runHive(this.hiveExec, "SELECT * FROM " + this.hiveMetaStore.tableNameConverter(hiveTableName));
        String[] rows = result.split("\n");
        Assert.assertEquals((long)(batchNum * batchSize), (long)rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String[] parts = HiveTestUtils.parseOutput(rows[i]);
            int j = 0;
            for (String expectedValue : (List)expectedResults.get(i)) {
                Assert.assertEquals((Object)expectedValue, (Object)parts[j++]);
            }
        }
    }

    @Test
    public void testHiveIntegrationFieldPartitionerParquetMultiple() throws Exception {
        this.localProps.put("hive.integration", "true");
        this.localProps.put("partitioner.class", FieldPartitioner.class.getName());
        this.localProps.put("partition.field.name", "country,state");
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        Schema schema = SchemaBuilder.struct().field("count", Schema.INT64_SCHEMA).field("country", Schema.STRING_SCHEMA).field("state", Schema.OPTIONAL_STRING_SCHEMA).build();
        List<Struct> records = Arrays.asList(new Struct(schema).put("count", (Object)1L).put("country", (Object)"us").put("state", (Object)"tx"), new Struct(schema).put("count", (Object)1L).put("country", (Object)"us").put("state", (Object)"ca"), new Struct(schema).put("count", (Object)1L).put("country", (Object)"mx").put("state", null));
        List<SinkRecord> sinkRecords = this.createSinkRecords(records, schema);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Object field : schema.fields()) {
            expectedColumnNames.add(field.name());
        }
        Collections.sort(expectedColumnNames);
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getAllCols()) {
            actualColumnNames.add(column.getName());
        }
        Collections.sort(actualColumnNames);
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        String topicsDir = (String)this.topicsDir.get("test-topic");
        ArrayList<String> expectedPartitions = new ArrayList<String>();
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)"test-topic/country=mx/state=null"));
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)"test-topic/country=us/state=ca"));
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)"test-topic/country=us/state=tx"));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
        List<List> expectedResults = Arrays.asList(Arrays.asList("1", "mx", "null"), Arrays.asList("1", "us", "ca"), Arrays.asList("1", "us", "tx"));
        String result = HiveTestUtils.runHive(this.hiveExec, "SELECT * FROM " + this.hiveMetaStore.tableNameConverter(hiveTableName));
        String[] rows = result.split("\n");
        Assert.assertEquals((long)expectedResults.size(), (long)rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String[] parts = HiveTestUtils.parseOutput(rows[i]);
            int j = 0;
            for (String expectedValue : expectedResults.get(i)) {
                Assert.assertEquals((Object)expectedValue, (Object)parts[j++]);
            }
        }
    }

    @Test
    public void testHiveIntegrationTimeBasedPartitionerParquet() throws Exception {
        String[] groups;
        this.localProps.put("hive.integration", "true");
        this.localProps.put("partitioner.class", DailyPartitioner.class.getName());
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        Schema schema = this.createSchema();
        List<Struct> records = this.createRecordBatches(schema, 3, 3);
        List<SinkRecord> sinkRecords = this.createSinkRecords(records, schema);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Object field : schema.fields()) {
            expectedColumnNames.add(field.name());
        }
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        String pathFormat = "'year'=YYYY/'month'=MM/'day'=dd";
        DateTime dateTime = DateTime.now((DateTimeZone)DateTimeZone.forID((String)"America/Los_Angeles"));
        String encodedPartition = TimeUtils.encodeTimestamp(TimeUnit.HOURS.toMillis(24L), pathFormat, "America/Los_Angeles", dateTime.getMillis());
        String directory = "test-topic/" + encodedPartition;
        String topicsDir = (String)this.topicsDir.get("test-topic");
        ArrayList<String> expectedPartitions = new ArrayList<String>();
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)topicsDir, (String)directory));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
        ArrayList<String> partitionFields = new ArrayList<String>();
        for (String group : groups = encodedPartition.split("/")) {
            String field = group.split("=")[1];
            partitionFields.add(field);
        }
        ArrayList<List<String>> expectedResults = new ArrayList<List<String>>();
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                List<String> result = Arrays.asList("true", String.valueOf(16 + i), String.valueOf((long)(16 + i)), String.valueOf(12.2f + (float)i), String.valueOf((double)(12.2f + (float)i)), (String)partitionFields.get(0), (String)partitionFields.get(1), (String)partitionFields.get(2));
                expectedResults.add(result);
            }
        }
        String result = HiveTestUtils.runHive(this.hiveExec, "SELECT * FROM " + this.hiveMetaStore.tableNameConverter(hiveTableName));
        String[] rows = result.split("\n");
        Assert.assertEquals((long)9L, (long)rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String[] parts = HiveTestUtils.parseOutput(rows[i]);
            int j = 0;
            for (String expectedValue : (List)expectedResults.get(i)) {
                Assert.assertEquals((Object)expectedValue, (Object)parts[j++]);
            }
        }
    }
}

