/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.parquet;

import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.parquet.ParquetDataFileReader;
import io.confluent.connect.hdfs.parquet.ParquetFormat;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Before;
import org.junit.Test;

public class DataWriterParquetTest
extends TestWithMiniDFSCluster {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dataFileReader = new ParquetDataFileReader();
        this.extension = ".parquet";
    }

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.put("format.class", ParquetFormat.class.getName());
        return props;
    }

    @Test
    public void testWriteRecord() throws Exception {
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        this.partitioner = hdfsWriter.getPartitioner();
        hdfsWriter.recover(TOPIC_PARTITION);
        List<SinkRecord> sinkRecords = this.createSinkRecords(7);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        long[] validOffsets = new long[]{0L, 3L, 6L};
        this.verify(sinkRecords, validOffsets);
    }
}

