/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.orc;

import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.hive.HiveTestBase;
import io.confluent.connect.hdfs.hive.HiveTestUtils;
import io.confluent.connect.hdfs.orc.OrcFormat;
import io.confluent.connect.hdfs.partitioner.DailyPartitioner;
import io.confluent.connect.hdfs.partitioner.FieldPartitioner;
import io.confluent.connect.hdfs.partitioner.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HiveIntegrationOrcTest
extends HiveTestBase {
    private final Map<String, String> localProps = new HashMap<String, String>();
    private final String hiveTableNameConfig;

    public HiveIntegrationOrcTest(String hiveTableNameConfig) {
        this.hiveTableNameConfig = hiveTableNameConfig;
    }

    @Parameterized.Parameters(name="{index}: hiveTableNameConfig={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"${topic}"}, {"a-${topic}-table"});
    }

    @Before
    public void beforeTest() {
        this.localProps.put("hive.table.name", this.hiveTableNameConfig);
    }

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.put("shutdown.timeout.ms", "10000");
        props.put("format.class", OrcFormat.class.getName());
        props.putAll(this.localProps);
        return props;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testSyncWithHiveOrc() throws Exception {
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.recover(TOPIC_PARTITION);
        List<SinkRecord> sinkRecords = this.createSinkRecords(7);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        this.localProps.put("hive.integration", "true");
        HdfsSinkConnectorConfig config = new HdfsSinkConnectorConfig(this.createProps());
        hdfsWriter = new DataWriter(config, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.syncWithHive();
        Schema schema = this.createSchema();
        Struct expectedRecord = this.createRecord(schema);
        ArrayList<String> expectedResult = new ArrayList<String>();
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Field field : schema.fields()) {
            expectedColumnNames.add(field.name());
            expectedResult.add(String.valueOf(expectedRecord.get(field.name())));
        }
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        List<String> expectedPartitions = Arrays.asList(this.partitionLocation("test-topic", 12));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
        hdfsWriter.close();
        hdfsWriter.stop();
    }

    @Test
    public void testHiveIntegrationOrc() throws Exception {
        this.localProps.put("hive.integration", "true");
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.recover(TOPIC_PARTITION);
        List<SinkRecord> sinkRecords = this.createSinkRecords(7);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        Schema schema = this.createSchema();
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Object field : schema.fields()) {
            expectedColumnNames.add(field.name());
        }
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        List<String> expectedPartitions = Arrays.asList(this.partitionLocation("test-topic", 12));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
    }

    @Test
    public void testHiveIntegrationFieldPartitionerOrc() throws Exception {
        this.localProps.put("hive.integration", "true");
        this.localProps.put("partitioner.class", FieldPartitioner.class.getName());
        this.localProps.put("partition.field.name", "int");
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        Schema schema = this.createSchema();
        List<Struct> records = this.createRecordBatches(schema, 3, 3);
        List<SinkRecord> sinkRecords = this.createSinkRecords(records, schema);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Object field : schema.fields()) {
            expectedColumnNames.add(field.name());
        }
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        List partitionFieldNames = this.connectorConfig.getList("partition.field.name");
        String partitionFieldName = (String)partitionFieldNames.get(0);
        String directory1 = "test-topic/" + partitionFieldName + "=" + 16;
        String directory2 = "test-topic/" + partitionFieldName + "=" + 17;
        String directory3 = "test-topic/" + partitionFieldName + "=" + 18;
        ArrayList<String> expectedPartitions = new ArrayList<String>();
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)((String)this.topicsDir.get("test-topic")), (String)directory1));
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)((String)this.topicsDir.get("test-topic")), (String)directory2));
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)((String)this.topicsDir.get("test-topic")), (String)directory3));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
        ArrayList expectedResults = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<String> result = new ArrayList<String>();
                for (Field field : schema.fields()) {
                    result.add(String.valueOf(records.get(i).get(field.name())));
                }
                expectedResults.add(result);
            }
        }
        String result = HiveTestUtils.runHive(this.hiveExec, "SELECT * FROM " + this.hiveMetaStore.tableNameConverter(hiveTableName));
        String[] rows = result.split("\n");
        Assert.assertEquals((long)9L, (long)rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String[] parts = HiveTestUtils.parseOutput(rows[i]);
            int j = 0;
            for (String expectedValue : (List)expectedResults.get(i)) {
                Assert.assertEquals((Object)expectedValue, (Object)parts[j++]);
            }
        }
    }

    @Test
    public void testHiveIntegrationTimeBasedPartitionerOrc() throws Exception {
        String[] groups;
        this.localProps.put("hive.integration", "true");
        this.localProps.put("partitioner.class", DailyPartitioner.class.getName());
        this.setUp();
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        Schema schema = this.createSchema();
        List<Struct> records = this.createRecordBatches(schema, 3, 3);
        List<SinkRecord> sinkRecords = this.createSinkRecords(records, schema);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Object field : schema.fields()) {
            expectedColumnNames.add(field.name());
        }
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        String pathFormat = "'year'=YYYY/'month'=MM/'day'=dd";
        DateTime dateTime = DateTime.now((DateTimeZone)DateTimeZone.forID((String)"America/Los_Angeles"));
        String encodedPartition = TimeUtils.encodeTimestamp(TimeUnit.HOURS.toMillis(24L), pathFormat, "America/Los_Angeles", dateTime.getMillis());
        String directory = "test-topic/" + encodedPartition;
        ArrayList<String> expectedPartitions = new ArrayList<String>();
        expectedPartitions.add(FileUtils.directoryName((String)this.url, (String)((String)this.topicsDir.get("test-topic")), (String)directory));
        List partitions = this.hiveMetaStore.listPartitions(this.hiveDatabase, hiveTableName, (short)-1);
        Assert.assertEquals(expectedPartitions, (Object)partitions);
        ArrayList<String> partitionFields = new ArrayList<String>();
        for (String group : groups = encodedPartition.split("/")) {
            String field = group.split("=")[1];
            partitionFields.add(field);
        }
        ArrayList<List<String>> expectedResults = new ArrayList<List<String>>();
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                List<String> result = Arrays.asList("true", String.valueOf(16 + i), String.valueOf((long)(16 + i)), String.valueOf(12.2f + (float)i), String.valueOf((double)(12.2f + (float)i)), (String)partitionFields.get(0), (String)partitionFields.get(1), (String)partitionFields.get(2));
                expectedResults.add(result);
            }
        }
        String result = HiveTestUtils.runHive(this.hiveExec, "SELECT * FROM " + this.hiveMetaStore.tableNameConverter(hiveTableName));
        String[] rows = result.split("\n");
        Assert.assertEquals((long)9L, (long)rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String[] parts = HiveTestUtils.parseOutput(rows[i]);
            int j = 0;
            for (String expectedValue : (List)expectedResults.get(i)) {
                Assert.assertEquals((Object)expectedValue, (Object)parts[j++]);
            }
        }
    }
}

