/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.orc;

import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.orc.OrcDataFileReader;
import io.confluent.connect.hdfs.orc.OrcFormat;
import io.confluent.connect.hdfs.orc.OrcUtil;
import io.confluent.connect.storage.hive.HiveSchemaConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaProjector;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataWriterOrcTest
extends TestWithMiniDFSCluster {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dataFileReader = new OrcDataFileReader();
        this.extension = ".orc";
    }

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.put("format.class", OrcFormat.class.getName());
        return props;
    }

    @Test
    public void testWriteRecord() throws Exception {
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        this.partitioner = hdfsWriter.getPartitioner();
        hdfsWriter.recover(TOPIC_PARTITION);
        List<SinkRecord> sinkRecords = this.createSinkRecords(7);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        long[] validOffsets = new long[]{0L, 3L, 6L};
        this.verify(sinkRecords, validOffsets);
    }

    @Override
    protected void verifyContents(List<SinkRecord> expectedRecords, int startIndex, Collection<Object> records) {
        Schema expectedSchema = null;
        for (Object orcRecord : records) {
            if (expectedSchema == null) {
                expectedSchema = expectedRecords.get(startIndex).valueSchema();
            }
            Object expectedValue = SchemaProjector.project((Schema)expectedRecords.get(startIndex).valueSchema(), (Object)expectedRecords.get(startIndex++).value(), (Schema)expectedSchema);
            TypeInfo typeInfo = HiveSchemaConverter.convert((Schema)expectedSchema);
            ArrayList<Object> objs = new ArrayList<Object>();
            for (Field field : expectedSchema.fields()) {
                objs.add(((Struct)expectedValue).get(field));
            }
            expectedValue = OrcUtil.createOrcStruct((TypeInfo)typeInfo, (Object[])objs.toArray(new Object[0]));
            Assert.assertEquals((Object)expectedValue.toString(), (Object)orcRecord.toString());
        }
    }
}

