/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.hive;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.hive.HiveTestBase;
import io.confluent.connect.hdfs.hive.HiveTestUtils;
import io.confluent.connect.hdfs.partitioner.Partitioner;
import io.confluent.connect.storage.hive.HiveUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class HiveUtilTestBase
extends HiveTestBase {
    private final Map<String, String> localProps = new HashMap<String, String>();
    private final String hiveTableNameConfig;
    private HiveUtil hive;

    public HiveUtilTestBase(String hiveTableNameConfig) {
        this.hiveTableNameConfig = hiveTableNameConfig;
    }

    @Parameterized.Parameters(name="{index}: hiveTableNameConfig={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"${topic}"}, {"a-${topic}-table"});
    }

    @Before
    public void beforeTest() {
        this.localProps.put("hive.table.name", this.hiveTableNameConfig);
    }

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.putAll(this.localProps);
        return props;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.hive = this.createHiveUtil();
    }

    protected abstract HiveUtil createHiveUtil();

    @Test
    public void testCreateTable() throws Exception {
        this.setUp();
        this.prepareData("test-topic", 12);
        Partitioner partitioner = HiveTestUtils.getPartitioner(this.parsedConfig);
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Schema schema = this.createSchema();
        this.hive.createTable(this.hiveDatabase, hiveTableName, schema, (io.confluent.connect.storage.partitioner.Partitioner)partitioner, "test-topic");
        String location = "partition=12";
        this.hiveMetaStore.addPartition(this.hiveDatabase, hiveTableName, location);
        Struct expectedRecord = this.createRecord(schema);
        ArrayList<String> expectedResult = new ArrayList<String>();
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Field field : schema.fields()) {
            expectedColumnNames.add(field.name());
            expectedResult.add(String.valueOf(expectedRecord.get(field.name())));
        }
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        List partitionCols = table.getPartitionKeys();
        Assert.assertEquals((long)1L, (long)partitionCols.size());
        Assert.assertEquals((Object)"partition", (Object)((FieldSchema)partitionCols.get(0)).getName());
        String result = HiveTestUtils.runHive(this.hiveExec, "SELECT * FROM " + this.hiveMetaStore.tableNameConverter(hiveTableName));
        String[] rows = result.split("\n");
        Assert.assertEquals((long)6L, (long)rows.length);
        for (String row : rows) {
            String[] parts = HiveTestUtils.parseOutput(row);
            int j = 0;
            for (String expectedValue : expectedResult) {
                Assert.assertEquals((Object)expectedValue, (Object)parts[j++]);
            }
        }
    }

    @Test
    public void testAlterSchema() throws Exception {
        this.setUp();
        this.prepareData("test-topic", 12);
        Partitioner partitioner = HiveTestUtils.getPartitioner(this.parsedConfig);
        String hiveTableName = this.connectorConfig.getHiveTableName("test-topic");
        Schema schema = this.createSchema();
        this.hive.createTable(this.hiveDatabase, hiveTableName, schema, (io.confluent.connect.storage.partitioner.Partitioner)partitioner, "test-topic");
        String location = "partition=12";
        this.hiveMetaStore.addPartition(this.hiveDatabase, hiveTableName, location);
        Struct expectedRecord = this.createRecord(schema);
        ArrayList<String> expectedResult = new ArrayList<String>();
        ArrayList<String> expectedColumnNames = new ArrayList<String>();
        for (Field field : schema.fields()) {
            expectedColumnNames.add(field.name());
            expectedResult.add(String.valueOf(expectedRecord.get(field.name())));
        }
        Table table = this.hiveMetaStore.getTable(this.hiveDatabase, hiveTableName);
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        for (FieldSchema column : table.getSd().getCols()) {
            actualColumnNames.add(column.getName());
        }
        Assert.assertEquals(expectedColumnNames, actualColumnNames);
        Schema newSchema = this.createNewSchema();
        this.hive.alterSchema(this.hiveDatabase, hiveTableName, newSchema);
        String result = HiveTestUtils.runHive(this.hiveExec, "SELECT * from " + this.hiveMetaStore.tableNameConverter(hiveTableName));
        String[] rows = result.split("\n");
        Assert.assertEquals((long)6L, (long)rows.length);
        for (String row : rows) {
            String[] parts = HiveTestUtils.parseOutput(row);
            int j = 0;
            for (String expectedValue : expectedResult) {
                Assert.assertEquals((Object)expectedValue, (Object)parts[j++]);
            }
        }
    }

    private void prepareData(String topic, int partition) {
        TopicPartition tp = new TopicPartition(topic, partition);
        DataWriter hdfsWriter = this.createWriter((SinkTaskContext)this.context, this.avroData);
        hdfsWriter.recover(tp);
        List<SinkRecord> sinkRecords = this.createSinkRecords(7);
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
    }

    private DataWriter createWriter(SinkTaskContext context, AvroData avroData) {
        return new DataWriter(this.connectorConfig, context, avroData);
    }
}

