/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.hive;

import io.confluent.connect.hdfs.hive.HiveExec;
import io.confluent.connect.hdfs.partitioner.DefaultPartitioner;
import io.confluent.connect.hdfs.partitioner.Partitioner;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;

public class HiveTestUtils {
    public static Partitioner getPartitioner(Map<String, Object> parsedConfig) {
        DefaultPartitioner partitioner = new DefaultPartitioner();
        partitioner.configure(parsedConfig);
        return partitioner;
    }

    public static String[] parseOutput(String output) {
        return output.replace(" ", "").split("\t");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runHive(HiveExec hiveExec, String query) throws Exception {
        String line;
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream errBytes = new ByteArrayOutputStream();
        PrintStream outSaved = System.out;
        PrintStream errSaved = System.err;
        System.setOut(new PrintStream(outBytes, true));
        System.setErr(new PrintStream(errBytes, true));
        try {
            hiveExec.executeQuery(query);
        }
        finally {
            System.setOut(outSaved);
            System.setErr(errSaved);
        }
        ByteArrayInputStream outBytesIn = new ByteArrayInputStream(outBytes.toByteArray());
        ByteArrayInputStream errBytesIn = new ByteArrayInputStream(errBytes.toByteArray());
        BufferedReader is = new BufferedReader(new InputStreamReader(outBytesIn));
        BufferedReader es = new BufferedReader(new InputStreamReader(errBytesIn));
        StringBuilder output = new StringBuilder();
        while ((line = is.readLine()) != null) {
            if (output.length() > 0) {
                output.append("\n");
            }
            output.append(line);
        }
        if (output.length() == 0) {
            output = new StringBuilder();
            while ((line = es.readLine()) != null) {
                output.append("\n");
                output.append(line);
            }
        }
        return output.toString();
    }
}

