/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.hive;

import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.hive.HiveExec;
import io.confluent.connect.hdfs.hive.HiveMetaStore;
import java.util.Map;
import org.junit.After;

public class HiveTestBase
extends TestWithMiniDFSCluster {
    protected String hiveDatabase;
    protected HiveMetaStore hiveMetaStore;
    protected HiveExec hiveExec;

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.put("hive.conf.dir", "src/test/resources/conf");
        return props;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.hiveDatabase = this.connectorConfig.getString("hive.database");
        this.hiveMetaStore = new HiveMetaStore(this.conf, this.connectorConfig);
        this.hiveExec = new HiveExec(this.connectorConfig);
        this.cleanHive();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.cleanHive();
        super.tearDown();
    }

    private void cleanHive() {
        for (String database : this.hiveMetaStore.getAllDatabases()) {
            for (String table : this.hiveMetaStore.getAllTables(database)) {
                this.hiveMetaStore.dropTable(database, table);
            }
            if ("default".equals(database)) continue;
            this.hiveMetaStore.dropDatabase(database, false);
        }
    }

    protected String partitionLocation(String topic, int partition) {
        return this.partitionLocation(topic, partition, "partition");
    }

    protected String partitionLocation(String topic, int partition, String partitionField) {
        String directory = topic + "/" + partitionField + "=" + partition;
        String topicsDir = this.connectorConfig.getTopicsDirFromTopic(topic);
        return FileUtils.directoryName((String)this.url, (String)topicsDir, (String)directory);
    }
}

