/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.hive;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;

public class HiveExec {
    public static final Log log = LogFactory.getLog(HiveExec.class);
    private HiveConf hiveConf = new HiveConf();
    private CliDriver cliDriver;
    private static final String HIVE_SASL_ENABLED = "hive.metastore.sasl.enabled";

    public HiveExec(HdfsSinkConnectorConfig config) {
        String hiveConfDir = config.getString("hive.conf.dir");
        this.hiveConf.addResource(new Path(hiveConfDir, "hive-site.xml"));
        SessionState.start((SessionState)new CliSessionState(this.hiveConf));
        this.cliDriver = new CliDriver();
    }

    public void executeQuery(String query) throws IOException {
        try {
            log.debug((Object)"Using in-process Hive instance.");
            String[] argv = this.getHiveArgs("-S", "-e", query);
            int status = this.cliDriver.run(argv);
            if (status != 0) {
                throw new IOException("Hive CliDriver exited with status=" + status);
            }
        }
        catch (Exception e) {
            throw new IOException("Exception thrown in Hive", e);
        }
    }

    private String[] getHiveArgs(String ... args) {
        LinkedList<String> newArgs = new LinkedList<String>();
        newArgs.addAll(Arrays.asList(args));
        if (this.hiveConf.getBoolean(HIVE_SASL_ENABLED, false)) {
            newArgs.add("--hiveconf");
            newArgs.add("hive.metastore.sasl.enabled=true");
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }
}

