/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.filter;

import io.confluent.connect.hdfs.filter.CommittedFileFilter;
import io.confluent.connect.hdfs.filter.TopicCommittedFileFilter;
import io.confluent.connect.hdfs.filter.TopicPartitionCommittedFileFilter;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kafka.common.TopicPartition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommittedFileFilterTest {
    private static FileSystem fs;
    private static Path ROOT_PATH;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.file.impl", "org.apache.hadoop.fs.RawLocalFileSystem");
        fs = FileSystem.newInstance((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        fs.deleteOnExit(ROOT_PATH);
        if (fs != null) {
            fs.close();
        }
    }

    @Test
    public void testTopicPartitionCommittedFileFilter() throws Exception {
        Path log = new Path(ROOT_PATH, "log");
        Path oldLog = new Path(ROOT_PATH, "log.1");
        String tempName = UUID.randomUUID().toString() + "_tmp";
        Path tmp = new Path(ROOT_PATH, tempName);
        Path valid1 = new Path(ROOT_PATH, "topic+1+2+3.abc");
        Path valid2 = new Path(ROOT_PATH, "topic+1+55+67.def");
        Path validOtherTopic = new Path(ROOT_PATH, "namespace.topic+1+55+67.def");
        Path invalid1 = new Path(ROOT_PATH, "1+2+3");
        Path invalid2 = new Path(ROOT_PATH, "a_b_c_d");
        Path invalid3 = new Path(ROOT_PATH, "tmp");
        Path invalid4 = new Path(ROOT_PATH, "a.b");
        Path invalid5 = new Path(ROOT_PATH, "topic_234_56_78.ghi");
        Path invalid6 = new Path(ROOT_PATH, "topic_34_56_7.hjk");
        fs.createNewFile(log);
        fs.createNewFile(oldLog);
        fs.createNewFile(tmp);
        fs.createNewFile(valid1);
        fs.createNewFile(valid2);
        fs.createNewFile(validOtherTopic);
        fs.createNewFile(invalid1);
        fs.createNewFile(invalid2);
        fs.createNewFile(invalid3);
        fs.createNewFile(invalid4);
        fs.createNewFile(invalid5);
        fs.createNewFile(invalid6);
        TopicPartition tp = new TopicPartition("topic", 1);
        FileStatus[] statuses = fs.listStatus(ROOT_PATH, (PathFilter)new TopicPartitionCommittedFileFilter(tp));
        HashSet<String> files = new HashSet<String>();
        for (FileStatus status : statuses) {
            files.add(status.getPath().getName());
        }
        Assert.assertEquals((long)2L, (long)files.size());
        Assert.assertTrue((boolean)files.contains(valid1.getName()));
        Assert.assertTrue((boolean)files.contains(valid2.getName()));
        TopicPartition tp2 = new TopicPartition("namespace.topic", 1);
        FileStatus[] statusesOtherTopic = fs.listStatus(ROOT_PATH, (PathFilter)new TopicPartitionCommittedFileFilter(tp2));
        Assert.assertEquals((long)1L, (long)statusesOtherTopic.length);
        Assert.assertEquals((Object)validOtherTopic.getName(), (Object)statusesOtherTopic[0].getPath().getName());
        fs.deleteOnExit(ROOT_PATH);
    }

    @Test
    public void testTopicCommittedFileFilter() throws Exception {
        Path log = new Path(ROOT_PATH, "log");
        Path oldLog = new Path(ROOT_PATH, "log.1");
        String tempName = UUID.randomUUID().toString() + "_tmp";
        Path tmp = new Path(ROOT_PATH, tempName);
        Path valid1 = new Path(ROOT_PATH, "topic+1+2+3.abc");
        Path valid2 = new Path(ROOT_PATH, "topic+1+55+67.def");
        Path valid3 = new Path(ROOT_PATH, "topic+234+56+78.ghi");
        Path valid4 = new Path(ROOT_PATH, "topic+34+56+7.hjk");
        Path validOtherTopic = new Path(ROOT_PATH, "namespace.topic+34+56+7.hjk");
        Path invalid1 = new Path(ROOT_PATH, "1+2+3");
        Path invalid2 = new Path(ROOT_PATH, "a_b_c_d");
        Path invalid3 = new Path(ROOT_PATH, "tmp");
        Path invalid4 = new Path(ROOT_PATH, "a.b");
        fs.createNewFile(log);
        fs.createNewFile(oldLog);
        fs.createNewFile(tmp);
        fs.createNewFile(valid1);
        fs.createNewFile(valid2);
        fs.createNewFile(valid3);
        fs.createNewFile(valid4);
        fs.createNewFile(validOtherTopic);
        fs.createNewFile(invalid1);
        fs.createNewFile(invalid2);
        fs.createNewFile(invalid3);
        fs.createNewFile(invalid4);
        FileStatus[] statuses = fs.listStatus(ROOT_PATH, (PathFilter)new TopicCommittedFileFilter("topic"));
        HashSet<String> files = new HashSet<String>();
        for (FileStatus status : statuses) {
            files.add(status.getPath().getName());
        }
        Assert.assertEquals((long)4L, (long)files.size());
        Assert.assertTrue((boolean)files.contains(valid1.getName()));
        Assert.assertTrue((boolean)files.contains(valid2.getName()));
        Assert.assertTrue((boolean)files.contains(valid3.getName()));
        Assert.assertTrue((boolean)files.contains(valid4.getName()));
        FileStatus[] statusesOtherTopic = fs.listStatus(ROOT_PATH, (PathFilter)new TopicCommittedFileFilter("namespace.topic"));
        Assert.assertEquals((long)1L, (long)statusesOtherTopic.length);
        Assert.assertEquals((Object)validOtherTopic.getName(), (Object)statusesOtherTopic[0].getPath().getName());
        fs.deleteOnExit(ROOT_PATH);
    }

    @Test
    public void testCommittedFileFilter() throws Exception {
        Path valid1 = new Path(ROOT_PATH, "__234+1+2+3.abc");
        Path valid2 = new Path(ROOT_PATH, "456+1+55+67.def");
        Path valid3 = new Path(ROOT_PATH, "topic+234+56+78.ghi");
        Path valid4 = new Path(ROOT_PATH, "topic+34+56+7.hjk");
        Path valid5 = new Path(ROOT_PATH, "--._+34+56+7.hjk");
        Path valid6 = new Path(ROOT_PATH, "topic+234+56+78");
        Path invalid1 = new Path(ROOT_PATH, "topic+234+56+78.");
        fs.createNewFile(valid1);
        fs.createNewFile(valid2);
        fs.createNewFile(valid3);
        fs.createNewFile(valid4);
        fs.createNewFile(valid5);
        fs.createNewFile(valid6);
        fs.createNewFile(invalid1);
        FileStatus[] statuses = fs.listStatus(ROOT_PATH, (PathFilter)new CommittedFileFilter());
        HashSet<String> files = new HashSet<String>();
        for (FileStatus status : statuses) {
            files.add(status.getPath().getName());
        }
        Assert.assertEquals((long)6L, (long)files.size());
        Assert.assertTrue((boolean)files.contains(valid1.getName()));
        Assert.assertTrue((boolean)files.contains(valid2.getName()));
        Assert.assertTrue((boolean)files.contains(valid3.getName()));
        Assert.assertTrue((boolean)files.contains(valid4.getName()));
        Assert.assertTrue((boolean)files.contains(valid5.getName()));
        Assert.assertTrue((boolean)files.contains(valid6.getName()));
        fs.deleteOnExit(ROOT_PATH);
    }

    static {
        ROOT_PATH = new Path(System.getProperty("test.build.data", "build/test/data"));
    }
}

