/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.HdfsSinkConnectorTestBase;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class TestWithSecureMiniDFSCluster
extends HdfsSinkConnectorTestBase {
    private static File baseDir;
    private static FileSystem fs;
    private static MiniDFSCluster cluster;
    private static String hdfsPrincipal;
    private static MiniKdc kdc;
    private static String keytab;
    private static String spnegoPrincipal;
    private static String connectorPrincipal;
    private static String connectorKeytab;

    @BeforeClass
    public static void setup() throws Exception {
        TestWithSecureMiniDFSCluster.initKdc();
        cluster = TestWithSecureMiniDFSCluster.createDFSCluster();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void cleanup() throws IOException {
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown(true);
        }
        UserGroupInformation.reset();
        TestWithSecureMiniDFSCluster.shutdownKdc();
    }

    private static void initKdc() throws Exception {
        baseDir = new File(System.getProperty("test.build.dir", "target/test-dir"));
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        File keytabFile = new File(baseDir, "hdfs.keytab");
        keytab = keytabFile.getAbsolutePath();
        kdc.createPrincipal(keytabFile, new String[]{"hdfs/localhost", "HTTP/localhost"});
        hdfsPrincipal = "hdfs/localhost@" + kdc.getRealm();
        spnegoPrincipal = "HTTP/localhost@" + kdc.getRealm();
        keytabFile = new File(baseDir, "connect-hdfs.keytab");
        connectorKeytab = keytabFile.getAbsolutePath();
        kdc.createPrincipal(keytabFile, new String[]{"connect-hdfs/localhost"});
        connectorPrincipal = "connect-hdfs/localhost@" + kdc.getRealm();
    }

    private static void shutdownKdc() {
        if (kdc != null) {
            kdc.stop();
        }
        FileUtil.fullyDelete((File)baseDir);
    }

    @Override
    public void setUp() throws Exception {
        Map<String, String> props = this.createProps();
        this.connectorConfig = new HdfsSinkConnectorConfig(props);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (fs.exists(new Path("/")) && fs.isDirectory(new Path("/"))) {
            for (FileStatus file : fs.listStatus(new Path("/"))) {
                if (file.isDirectory()) {
                    fs.delete(file.getPath(), true);
                    continue;
                }
                fs.delete(file.getPath(), false);
            }
        }
    }

    private static Configuration createSecureConfig(String dataTransferProtection) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        conf.set("dfs.namenode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.namenode.keytab.file", keytab);
        conf.set("dfs.datanode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.datanode.keytab.file", keytab);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", dataTransferProtection);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        conf.set("dfs.encrypt.data.transfer", "true");
        String keystoresDir = baseDir.getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestWithSecureMiniDFSCluster.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        return conf;
    }

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        this.url = "hdfs://" + cluster.getNameNode().getClientNamenodeAddress();
        props.put("hdfs.url", this.url);
        props.put("store.url", this.url);
        props.put("hdfs.authentication.kerberos", "true");
        props.put("connect.hdfs.principal", hdfsPrincipal);
        props.put("connect.hdfs.keytab", keytab);
        props.put("hdfs.namenode.principal", hdfsPrincipal);
        return props;
    }

    private static MiniDFSCluster createDFSCluster() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(TestWithSecureMiniDFSCluster.createSecureConfig("authentication")).hosts(new String[]{"localhost", "localhost", "localhost"}).nameNodePort(9001).numDataNodes(3).build();
        cluster.waitActive();
        return cluster;
    }
}

