/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.DataFileReader;
import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.HdfsSinkTask;
import io.confluent.connect.hdfs.TestWithSecureMiniDFSCluster;
import io.confluent.connect.hdfs.avro.AvroDataFileReader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Assert;
import org.junit.Test;

public class HdfsSinkTaskWithSecureHDFSTest
extends TestWithSecureMiniDFSCluster {
    private static final String extension = ".avro";
    private static final String ZERO_PAD_FMT = "%010d";
    private final DataFileReader schemaFileReader = new AvroDataFileReader();

    @Test
    public void testSinkTaskPut() throws Exception {
        this.setUp();
        HdfsSinkTask task = new HdfsSinkTask();
        String key = "key";
        Schema schema = this.createSchema();
        Struct record = this.createRecord(schema);
        ArrayList<SinkRecord> sinkRecords = new ArrayList<SinkRecord>();
        for (TopicPartition tp : this.context.assignment()) {
            for (long offset = 0L; offset < 7L; ++offset) {
                SinkRecord sinkRecord = new SinkRecord(tp.topic(), tp.partition(), Schema.STRING_SCHEMA, (Object)key, schema, (Object)record, offset);
                sinkRecords.add(sinkRecord);
            }
        }
        task.initialize((SinkTaskContext)this.context);
        task.start(this.properties);
        task.put(sinkRecords);
        task.stop();
        AvroData avroData = task.getAvroData();
        long[] validOffsets = new long[]{-1L, 2L, 5L};
        for (TopicPartition tp : this.context.assignment()) {
            String directory = tp.topic() + "/partition=" + String.valueOf(tp.partition());
            for (int j = 1; j < validOffsets.length; ++j) {
                long startOffset = validOffsets[j - 1] + 1L;
                long endOffset = validOffsets[j];
                String topicsDir = (String)this.topicsDir.get(tp.topic());
                Path path = new Path(FileUtils.committedFileName((String)this.url, (String)topicsDir, (String)directory, (TopicPartition)tp, (long)startOffset, (long)endOffset, (String)extension, (String)ZERO_PAD_FMT));
                Collection<Object> records = this.schemaFileReader.readData(this.connectorConfig.getHadoopConfiguration(), path);
                long size = endOffset - startOffset + 1L;
                Assert.assertEquals((long)records.size(), (long)size);
                for (Object avroRecord : records) {
                    Assert.assertEquals((Object)avroRecord, (Object)avroData.fromConnectData(schema, (Object)record));
                }
            }
        }
    }
}

