/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.avro.AvroFormat;
import io.confluent.connect.hdfs.partitioner.DefaultPartitioner;
import io.confluent.connect.storage.StorageSinkTestBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.junit.After;

public class HdfsSinkConnectorTestBase
extends StorageSinkTestBase {
    protected HdfsSinkConnectorConfig connectorConfig;
    protected Map<String, Object> parsedConfig;
    protected Configuration conf;
    protected HashMap<String, String> topicsDir;
    protected String logsDir;
    protected AvroData avroData;
    protected static final String TOPIC_WITH_DOTS = "topic.with.dots";
    protected static final TopicPartition TOPIC_WITH_DOTS_PARTITION = new TopicPartition("topic.with.dots", 12);

    protected Map<String, String> createProps() {
        Map props = super.createProps();
        this.url = "memory://";
        props.put("hdfs.url", this.url);
        props.put("store.url", this.url);
        props.put("flush.size", "3");
        props.put("storage.class", "io.confluent.connect.hdfs.storage.HdfsStorage");
        props.put("format.class", AvroFormat.class.getName());
        props.put("partitioner.class", DefaultPartitioner.class.getName());
        props.put("partition.field.name", "int");
        props.put("partition.duration.ms", String.valueOf(TimeUnit.HOURS.toMillis(1L)));
        props.put("path.format", "'year'=YYYY/'month'=MM/'day'=dd/'hour'=HH/");
        props.put("locale", "en");
        props.put("timezone", "America/Los_Angeles");
        props.put("topic.capture.groups.regex", "(.*)[\\.\\-](.*)");
        props.put("topics.dir", "${1}/${topic}");
        return props;
    }

    protected Struct createRecord(Schema schema, int ibase, float fbase) {
        return new Struct(schema).put("boolean", (Object)true).put("int", (Object)ibase).put("long", (Object)ibase).put("float", (Object)Float.valueOf(fbase)).put("double", (Object)fbase);
    }

    protected List<Struct> createRecordBatch(Schema schema, int size) {
        ArrayList<Struct> records = new ArrayList<Struct>(size);
        int ibase = 16;
        float fbase = 12.2f;
        for (int i = 0; i < size; ++i) {
            records.add(this.createRecord(schema, ibase + i, fbase + (float)i));
        }
        return records;
    }

    protected List<Struct> createRecordBatches(Schema schema, int batchSize, int batchesNum) {
        ArrayList<Struct> records = new ArrayList<Struct>();
        for (int i = 0; i < batchesNum; ++i) {
            records.addAll(this.createRecordBatch(schema, batchSize));
        }
        return records;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        this.parsedConfig = new HashMap<String, Object>(this.connectorConfig.plainValues());
        this.conf = this.connectorConfig.getHadoopConfiguration();
        this.topicsDir = new HashMap();
        for (TopicPartition tp : this.context.assignment()) {
            this.topicsDir.computeIfAbsent(tp.topic(), topic -> this.connectorConfig.getTopicsDirFromTopic(topic));
        }
        this.logsDir = this.connectorConfig.getString("logs.dir");
        this.avroData = new AvroData(this.connectorConfig.avroDataConfig());
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

