/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.avro.AvroFormat;
import io.confluent.connect.hdfs.json.JsonFormat;
import io.confluent.connect.hdfs.orc.OrcFormat;
import io.confluent.connect.hdfs.parquet.ParquetFormat;
import io.confluent.connect.hdfs.partitioner.DailyPartitioner;
import io.confluent.connect.hdfs.partitioner.DefaultPartitioner;
import io.confluent.connect.hdfs.partitioner.FieldPartitioner;
import io.confluent.connect.hdfs.partitioner.HourlyPartitioner;
import io.confluent.connect.hdfs.partitioner.Partitioner;
import io.confluent.connect.hdfs.partitioner.TimeBasedPartitioner;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.hdfs.string.StringFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HdfsSinkConnectorConfigTest
extends TestWithMiniDFSCluster {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testHiveTableName() {
        this.properties.put("hive.table.name", "a-${topic}-test");
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        Assert.assertEquals((Object)"a-test-topic-test", (Object)this.connectorConfig.getHiveTableName("test-topic"));
    }

    @Test
    public void testHiveTableNameValidation() {
        this.properties.put("hive.table.name", "static-table");
        ConfigException configException = (ConfigException)Assert.assertThrows(ConfigException.class, () -> new HdfsSinkConnectorConfig(this.properties));
        Assert.assertEquals((Object)"hive.table.name: 'static-table' has to contain topic substitution '${topic}'.", (Object)configException.getMessage());
        this.properties.put("hive.table.name", "${topic}-${extra}");
        configException = (ConfigException)Assert.assertThrows(ConfigException.class, () -> new HdfsSinkConnectorConfig(this.properties));
        Assert.assertEquals((Object)"hive.table.name: '${topic}-${extra}' contains an invalid ${} substitution '${extra}'. Valid substitution is '${topic}'", (Object)configException.getMessage());
    }

    @Test
    public void testValidRegexCaptureGroup() {
        String topic = "topica";
        String topicDir = "topic.another.${topic}.again";
        this.properties.put("topic.capture.groups.regex", ".*");
        this.properties.put("topics.dir", topicDir);
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        Assert.assertEquals((Object)topicDir.replace("${topic}", topic), (Object)this.connectorConfig.getTopicsDirFromTopic(topic));
    }

    @Test
    public void testTopicDirFromTopicParts() {
        String topic = "a.b.c.d";
        String topicDir = "${1}-${2}-${3}-${4}";
        this.properties.put("topic.capture.groups.regex", "([a-z])\\.([a-z])\\.([a-z])\\.([a-z])");
        this.properties.put("topics.dir", topicDir);
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        Assert.assertEquals((Object)topic.replace(".", "-"), (Object)this.connectorConfig.getTopicsDirFromTopic(topic));
    }

    @Test
    public void testTopicDirCanContainNumber() {
        String topic = "a.b.c.d";
        String topicDir = "${1}-${2}-${3}-${4}-1000";
        this.properties.put("topic.capture.groups.regex", "([a-z])[\\.\\-_]([a-z])[\\.\\-_]([a-z])[\\.\\-_]([a-z])");
        this.properties.put("topics.dir", topicDir);
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        Assert.assertEquals((Object)(topic.replace(".", "-") + "-1000"), (Object)this.connectorConfig.getTopicsDirFromTopic(topic));
    }

    @Test(expected=ConfigException.class)
    public void testInvalidTopicDir() {
        String topic = "a.b.c.d";
        String topicDir = "${100}-${2}-${3}-${4}";
        this.properties.put("topic.capture.groups.regex", "([a-z])\\.([a-z])\\.([a-z])\\.([a-z])");
        this.properties.put("topics.dir", topicDir);
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        this.connectorConfig.getTopicsDirFromTopic(topic);
    }

    @Test(expected=ConfigException.class)
    public void testInvalidTopicDirNegative() {
        String topic = "a.b.c.d";
        String topicDir = "${-1}-${2}-${3}-${4}";
        this.properties.put("topic.capture.groups.regex", "([a-z])\\.([a-z])\\.([a-z])\\.([a-z])");
        this.properties.put("topics.dir", topicDir);
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        this.connectorConfig.getTopicsDirFromTopic(topic);
    }

    @Test(expected=ConfigException.class)
    public void testInvalidRegexCaptureGroup() {
        String topicDir = "topic.another.${topic}.again";
        this.properties.put("topic.capture.groups.regex", "[a");
        this.properties.put("topics.dir", topicDir);
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
    }

    @Test(expected=ConfigException.class)
    public void testInvalidRegexCaptureGroupDoesntMatchTopic() {
        String topic = "topica";
        String topicDir = "topic.another.${topic}.again";
        this.properties.put("topic.capture.groups.regex", "[a-z]");
        this.properties.put("topics.dir", topicDir);
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        this.connectorConfig.getTopicsDirFromTopic(topic);
    }

    @Test(expected=ConfigException.class)
    public void testUrlConfigMustBeNonEmpty() {
        this.properties.remove("store.url");
        this.properties.remove("hdfs.url");
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
    }

    @Test
    public void testStorageCommonUrlPreferred() {
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        Assert.assertEquals((Object)this.url, (Object)this.connectorConfig.url());
    }

    @Test
    public void testHdfsUrlIsValid() {
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        this.properties.remove("store.url");
        Assert.assertEquals((Object)this.url, (Object)this.connectorConfig.url());
    }

    @Test
    public void testStorageClass() throws Exception {
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        Assert.assertEquals(HdfsStorage.class, (Object)this.connectorConfig.getClass("storage.class"));
    }

    @Test
    public void testUndefinedURL() throws Exception {
        this.properties.remove("store.url");
        this.connectorConfig = new HdfsSinkConnectorConfig(this.properties);
        Assert.assertNull((Object)this.connectorConfig.getString("store.url"));
    }

    @Test
    public void testAvroCompressionSettings() {
        for (String codec : HdfsSinkConnectorConfig.AVRO_SUPPORTED_CODECS) {
            HashMap<String, String> props = new HashMap<String, String>(this.properties);
            props.put("avro.codec", codec);
            HdfsSinkConnectorConfig config = new HdfsSinkConnectorConfig(props);
            Assert.assertNotNull((Object)config.getAvroCodec());
        }
    }

    @Test(expected=ConfigException.class)
    public void testUnsupportedAvroCompressionSettings() {
        this.properties.put("avro.codec", "abc");
        new HdfsSinkConnectorConfig(this.properties);
        Assert.assertTrue((String)"Expected the constructor to throw an exception", (boolean)false);
    }

    @Test
    public void testValidTimezoneWithScheduleIntervalAccepted() {
        this.properties.put("timezone", "CET");
        this.properties.put("rotate.schedule.interval.ms", "30");
        new HdfsSinkConnectorConfig(this.properties);
    }

    @Test(expected=ConfigException.class)
    public void testEmptyTimezoneThrowsExceptionOnScheduleInterval() {
        this.properties.put("timezone", "");
        this.properties.put("rotate.schedule.interval.ms", "30");
        new HdfsSinkConnectorConfig(this.properties);
    }

    @Test
    public void testEmptyTimezoneExceptionMessage() {
        this.properties.put("timezone", "");
        this.properties.put("rotate.schedule.interval.ms", "30");
        String expectedError = String.format("%s configuration must be set when using %s", "timezone", "rotate.schedule.interval.ms");
        try {
            new HdfsSinkConnectorConfig(this.properties);
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)expectedError, (Object)e.getMessage());
        }
    }

    @Test
    public void testRecommendedValues() throws Exception {
        List<Object> expectedStorageClasses = Arrays.asList(HdfsStorage.class);
        List<Object> expectedFormatClasses = Arrays.asList(AvroFormat.class, JsonFormat.class, OrcFormat.class, ParquetFormat.class, StringFormat.class);
        List<Object> expectedPartitionerClasses = Arrays.asList(io.confluent.connect.storage.partitioner.DefaultPartitioner.class, io.confluent.connect.storage.partitioner.HourlyPartitioner.class, io.confluent.connect.storage.partitioner.DailyPartitioner.class, io.confluent.connect.storage.partitioner.TimeBasedPartitioner.class, io.confluent.connect.storage.partitioner.FieldPartitioner.class);
        List values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            if (!(val.value() instanceof Class)) continue;
            switch (val.name()) {
                case "storage.class": {
                    Assert.assertEquals(expectedStorageClasses, (Object)val.recommendedValues());
                    break;
                }
                case "format.class": {
                    Assert.assertEquals(expectedFormatClasses, (Object)val.recommendedValues());
                    break;
                }
                case "partitioner.class": {
                    Assert.assertEquals(expectedPartitionerClasses, (Object)val.recommendedValues());
                }
            }
        }
    }

    @Test
    public void testVisibilityForPartitionerClassDependentConfigs() throws Exception {
        this.properties.put("partitioner.class", io.confluent.connect.storage.partitioner.DefaultPartitioner.class.getName());
        List values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": 
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertFalse((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", io.confluent.connect.storage.partitioner.FieldPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": {
                    Assert.assertTrue((boolean)val.visible());
                    break;
                }
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertFalse((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", io.confluent.connect.storage.partitioner.DailyPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": 
                case "partition.duration.ms": 
                case "path.format": {
                    Assert.assertFalse((boolean)val.visible());
                    break;
                }
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", io.confluent.connect.storage.partitioner.HourlyPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": 
                case "partition.duration.ms": 
                case "path.format": {
                    Assert.assertFalse((boolean)val.visible());
                    break;
                }
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", io.confluent.connect.storage.partitioner.TimeBasedPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
        io.confluent.connect.storage.partitioner.Partitioner<FieldSchema> klass = new io.confluent.connect.storage.partitioner.Partitioner<FieldSchema>(){

            public void configure(Map<String, Object> config) {
            }

            public String encodePartition(SinkRecord sinkRecord) {
                return null;
            }

            public String generatePartitionedPath(String topic, String encodedPartition) {
                return null;
            }

            public List<FieldSchema> partitionFields() {
                return null;
            }
        };
        this.properties.put("partitioner.class", klass.getClass().getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
    }

    @Test
    public void testVisibilityForDeprecatedPartitionerClassDependentConfigs() throws Exception {
        this.properties.put("partitioner.class", DefaultPartitioner.class.getName());
        List values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": 
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertFalse((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", FieldPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": {
                    Assert.assertTrue((boolean)val.visible());
                    break;
                }
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertFalse((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", DailyPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": 
                case "partition.duration.ms": 
                case "path.format": {
                    Assert.assertFalse((boolean)val.visible());
                    break;
                }
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", HourlyPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.field.name": 
                case "partition.duration.ms": 
                case "path.format": {
                    Assert.assertFalse((boolean)val.visible());
                    break;
                }
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
        this.properties.put("partitioner.class", TimeBasedPartitioner.class.getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
        Partitioner klass = new Partitioner(){

            public void configure(Map<String, Object> config) {
            }

            public String encodePartition(SinkRecord sinkRecord) {
                return null;
            }

            public String generatePartitionedPath(String topic, String encodedPartition) {
                return null;
            }

            public List<FieldSchema> partitionFields() {
                return null;
            }
        };
        this.properties.put("partitioner.class", klass.getClass().getName());
        values = HdfsSinkConnectorConfig.getConfig().validate(this.properties);
        for (ConfigValue val : values) {
            switch (val.name()) {
                case "partition.duration.ms": 
                case "path.format": 
                case "locale": 
                case "timezone": {
                    Assert.assertTrue((boolean)val.visible());
                }
            }
        }
    }
}

