/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.common.utils.MockTime;
import io.confluent.common.utils.Time;
import io.confluent.connect.hdfs.FileUtils;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.OldFormat;
import io.confluent.connect.hdfs.RecordWriterProvider;
import io.confluent.connect.hdfs.TestWithMiniDFSCluster;
import io.confluent.connect.hdfs.TopicPartitionWriter;
import io.confluent.connect.hdfs.avro.AvroDataFileReader;
import io.confluent.connect.hdfs.partitioner.DefaultPartitioner;
import io.confluent.connect.hdfs.partitioner.Partitioner;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.storage.StorageFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Before;
import org.junit.Test;

public class FormatAPITopicPartitionWriterCompatibilityTest
extends TestWithMiniDFSCluster {
    private RecordWriterProvider writerProvider = null;
    private io.confluent.connect.storage.format.RecordWriterProvider<HdfsSinkConnectorConfig> newWriterProvider;
    private HdfsStorage storage;
    private MockTime time;

    @Override
    protected Map<String, String> createProps() {
        return super.createProps();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.time = new MockTime();
        Class storageClass = this.connectorConfig.getClass("storage.class");
        this.storage = (HdfsStorage)StorageFactory.createStorage((Class)storageClass, HdfsSinkConnectorConfig.class, (Object)this.connectorConfig, (String)this.url);
        OldFormat format = new OldFormat();
        this.writerProvider = format.getRecordWriterProvider();
        this.newWriterProvider = null;
        this.dataFileReader = new AvroDataFileReader();
        this.extension = this.writerProvider.getExtension();
        String topicsDir = (String)this.topicsDir.get(TOPIC_PARTITION.topic());
        this.createTopicDir(this.url, topicsDir, "test-topic");
        this.createLogsDir(this.url, this.logsDir);
    }

    @Test
    public void testWriteRecordDefaultWithPadding() throws Exception {
        DefaultPartitioner partitioner = new DefaultPartitioner();
        partitioner.configure(this.parsedConfig);
        TopicPartitionWriter topicPartitionWriter = new TopicPartitionWriter(TOPIC_PARTITION, this.storage, this.writerProvider, this.newWriterProvider, (Partitioner)partitioner, this.connectorConfig, (SinkTaskContext)this.context, this.avroData, (Time)this.time);
        Schema schema = this.createSchema();
        List<Struct> records = this.createRecordBatches(schema, 3, 3);
        records.add(this.createRecord(schema));
        List<SinkRecord> sinkRecords = this.createSinkRecords(records, schema);
        for (SinkRecord record : sinkRecords) {
            topicPartitionWriter.buffer(record);
        }
        topicPartitionWriter.recover();
        topicPartitionWriter.write();
        topicPartitionWriter.close();
    }

    private void createTopicDir(String url, String topicsDir, String topic) throws IOException {
        Path path = new Path(FileUtils.topicDirectory((String)url, (String)topicsDir, (String)topic));
        if (!fs.exists(path)) {
            fs.mkdirs(path);
        }
    }

    private void createLogsDir(String url, String logsDir) throws IOException {
        Path path = new Path(url + "/" + logsDir);
        if (!fs.exists(path)) {
            fs.mkdirs(path);
        }
    }
}

