/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.OldFormat;
import io.confluent.connect.hdfs.avro.AvroDataFileReader;
import io.confluent.connect.hdfs.hive.HiveTestBase;
import java.util.ArrayList;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Before;
import org.junit.Test;

public class FormatAPIDataWriterCompatibilityTest
extends HiveTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dataFileReader = new AvroDataFileReader();
        this.extension = ".avro";
    }

    @Test
    public void dataWriterNewFormatAPICompatibilityTest() {
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.recover(TOPIC_PARTITION);
        String key = "key";
        Schema schema = this.createSchema();
        Struct record = this.createRecord(schema);
        ArrayList<SinkRecord> sinkRecords = new ArrayList<SinkRecord>();
        for (long offset = 0L; offset < 7L; ++offset) {
            SinkRecord sinkRecord = new SinkRecord("test-topic", 12, Schema.STRING_SCHEMA, (Object)key, schema, (Object)record, offset);
            sinkRecords.add(sinkRecord);
        }
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        Map<String, String> props = this.createProps();
        props.put("hive.integration", "true");
        HdfsSinkConnectorConfig config = new HdfsSinkConnectorConfig(props);
        hdfsWriter = new DataWriter(config, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.syncWithHive();
        hdfsWriter.close();
        hdfsWriter.stop();
    }

    @Test
    public void dataWriterNewFormatAPICompatibilityWithDefaultsTest() {
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.recover(TOPIC_PARTITION);
        String key = "key";
        Schema schema = this.createSchema();
        Struct record = this.createRecord(schema);
        ArrayList<SinkRecord> sinkRecords = new ArrayList<SinkRecord>();
        for (long offset = 0L; offset < 7L; ++offset) {
            SinkRecord sinkRecord = new SinkRecord("test-topic", 12, Schema.STRING_SCHEMA, (Object)key, schema, (Object)record, offset);
            sinkRecords.add(sinkRecord);
        }
        hdfsWriter.write(sinkRecords);
        hdfsWriter.close();
        hdfsWriter.stop();
        Map<String, String> props = this.createProps();
        props.remove("storage.class");
        props.remove("format.class");
        props.put("hive.integration", "true");
        HdfsSinkConnectorConfig config = new HdfsSinkConnectorConfig(props);
        hdfsWriter = new DataWriter(config, (SinkTaskContext)this.context, this.avroData);
        hdfsWriter.syncWithHive();
        hdfsWriter.close();
        hdfsWriter.stop();
    }

    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.put("format.class", OldFormat.class.getName());
        props.put("hive.integration", "true");
        return props;
    }
}

