/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.hdfs.DataWriter;
import io.confluent.connect.hdfs.avro.AvroDataFileReader;
import io.confluent.connect.hdfs.hive.HiveTestBase;
import io.confluent.connect.hdfs.partitioner.DefaultPartitioner;
import io.confluent.connect.hdfs.partitioner.Partitioner;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomPartitionerPropertiesTest
extends HiveTestBase {
    @Override
    protected Map<String, String> createProps() {
        Map<String, String> props = super.createProps();
        props.put("partitioner.class", CustomPartitioner.class.getName());
        props.put("custom.property", "expectThis");
        return props;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dataFileReader = new AvroDataFileReader();
        this.extension = ".avro";
    }

    @Test
    public void createDataWriterWithCustomPartitioner() {
        DataWriter hdfsWriter = new DataWriter(this.connectorConfig, (SinkTaskContext)this.context, this.avroData);
        Partitioner partitioner = hdfsWriter.getPartitioner();
        Assert.assertEquals((Object)CustomPartitioner.class.getName(), (Object)partitioner.getClass().getName());
        CustomPartitioner customPartitioner = (CustomPartitioner)partitioner;
        Assert.assertEquals((Object)"expectThis", (Object)customPartitioner.customValue());
        hdfsWriter.close();
        hdfsWriter.stop();
    }

    public static final class CustomPartitioner
    extends DefaultPartitioner {
        public static final String CUSTOM_PROPERTY = "custom.property";
        public static final String EXPECTED_VALUE = "expectThis";
        String customValue;

        public void configure(Map<String, Object> config) {
            super.configure(config);
            this.customValue = (String)config.get(CUSTOM_PROPERTY);
        }

        public String customValue() {
            return this.customValue;
        }
    }
}

