/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.agent.monitoring;

import io.confluent.agent.monitoring.Volume;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUsage {
    private static final Logger log = LoggerFactory.getLogger(DiskUsage.class);

    public static void premain(String configfile, Instrumentation instrumentation) {
        log.info("DiskUsage Agent: config : " + configfile);
        try {
            if (configfile != null && !configfile.isEmpty()) {
                Map config = DiskUsage.loadConfig(configfile);
                String serviceName = (String)config.get("service.name");
                Map<String, String> dirs = config.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith("disk.")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue()));
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                for (String dir : dirs.keySet()) {
                    String displayName = dir.replace("disk.", "");
                    String volume = dirs.get(dir);
                    String objectName = String.format("io.confluent.caas:type=VolumeMetrics, service=%s, dir=%s", serviceName, displayName);
                    ObjectName volumeMBeanName = new ObjectName(objectName);
                    Volume volumeMBean = new Volume(volume);
                    server.registerMBean(volumeMBean, volumeMBeanName);
                    Set<ObjectInstance> instances = server.queryMBeans(new ObjectName(objectName), null);
                    ObjectInstance instance = (ObjectInstance)instances.toArray()[0];
                    log.info("DiskUsage Agent: Registering object :" + instance.getObjectName() + " for class : " + instance.getClassName());
                    log.info("DiskUsage Agent: Ping " + volumeMBean.toString());
                }
            } else {
                log.error("Disk Agent: No config file provided.");
            }
        }
        catch (Exception e) {
            log.error("Error while running Disk Agent: ", (Throwable)e);
        }
    }

    public static Map loadConfig(String configFile) throws IOException {
        if (!Files.exists(Paths.get(configFile, new String[0]), new LinkOption[0])) {
            throw new RuntimeException("The config file location is invalid. " + configFile);
        }
        Properties cfg = new Properties();
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            cfg.load(inputStream);
        }
        return new HashMap<Object, Object>(cfg);
    }

    public static void agentmain(String agentArguments, Instrumentation instrumentation) {
        DiskUsage.premain(agentArguments, instrumentation);
    }

    public static void main(String ... args) throws InterruptedException {
        if (args.length == 1) {
            DiskUsage.premain(args[0], null);
        } else {
            System.out.println("Need to provide path to config");
        }
    }
}

