/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.agent.monitoring;

import io.confluent.agent.monitoring.DiskUsage;
import io.confluent.agent.monitoring.Volume;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class VolumeTest {
    @Ignore
    @Test
    public void testVolume() {
        try {
            Volume volume = new Volume(System.getProperty("java.io.tmpdir"));
            long total = volume.getTotal();
            long used = volume.getUsed();
            long available = volume.getAvailable();
            double percentAvailable = volume.getPercentAvailable();
            double percentUsed = volume.getPercentUsed();
            Assert.assertNotNull((Object)volume.getDeviceName());
            Assert.assertEquals((Object)volume.getMountpoint(), (Object)System.getProperty("java.io.tmpdir"));
            Assert.assertTrue((total > 0L ? 1 : 0) != 0);
            Assert.assertTrue((used > 0L ? 1 : 0) != 0);
            Assert.assertTrue((available > 0L ? 1 : 0) != 0);
            Assert.assertEquals((double)total, (double)(used + available), (double)((double)total * 0.05));
            Assert.assertTrue((percentAvailable > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((percentUsed > 0.0 ? 1 : 0) != 0);
            Assert.assertEquals((double)100.0, (double)(percentUsed + percentAvailable), (double)0.2);
        }
        catch (IOException e) {
            Assert.fail((String)"Should not fail.");
        }
    }

    @Test
    public void testDiskUsage() {
        try {
            TemporaryFolder tempFolder = new TemporaryFolder();
            String config = "service.name=kafka\ndisk.logs=/tmp";
            tempFolder.create();
            File tempFile = tempFolder.newFile("test.properties");
            Files.write(tempFile.toPath(), config.getBytes(), new OpenOption[0]);
            DiskUsage.premain((String)tempFile.getAbsolutePath(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should not fail.");
        }
    }
}

