/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration.strategies;

import io.confluent.kafka.schemaregistry.validator.integration.strategies.StrategyBrokerTest;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.InvalidRecordException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicRecordNameStrategyBrokerTest
extends StrategyBrokerTest {
    protected void setUp() throws Exception {
        super.setUp();
        this.createTopic(TopicRecordNameStrategy.class);
    }

    @Test
    public void testProducerHasTopicNameStrategyIsRejected() {
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(TopicNameStrategy.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)"key", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
            Assertions.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
    }

    @Test
    public void testProducerHasRecordNameStrategyIsRejected() {
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(RecordNameStrategy.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)"key", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
            Assertions.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
    }

    @Test
    public void testProducerHasTopicRecordNameStrategyIsAccepted() throws Exception {
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(TopicRecordNameStrategy.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)"key", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
        }
    }
}

