/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.validator.GarbageKafkaAvroSerializer;
import io.confluent.kafka.schemaregistry.validator.integration.RecordSchemaValidatorIntegrationTestHarness;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.Collections;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueValidationTest
extends RecordSchemaValidatorIntegrationTestHarness {
    public ValueValidationTest() {
        super(3, true, CompatibilityLevel.NONE.name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        NewTopic testTopic = new NewTopic("test", 1, 1);
        testTopic.configs(Collections.singletonMap("confluent.value.schema.validation", "true"));
        this.createTopicThroughAdminClient(testTopic);
    }

    @Test
    public void testCorrectlyFormattedDataIsAccepted() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(StringSerializer.class, KafkaAvroSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
        }
        catch (Exception e) {
            Assertions.fail((String)"The future is supposed to succeed");
        }
    }

    @Test
    public void testGarbageValueDataIsRejected() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(StringSerializer.class, GarbageKafkaAvroSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
            Assertions.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
        this.checkMetricsAreRecorded();
    }

    @Test
    public void testGarbageKeyDataIsAccepted() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(GarbageKafkaAvroSerializer.class, KafkaAvroSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
        }
        catch (Exception e) {
            Assertions.fail((String)"The future is supposed to succeed");
        }
    }

    @Test
    public void testNonExistentSchemaDataIsRejected() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(StringSerializer.class, ByteArraySerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.messageContentWithInvalidSchemaId());
            kafkaProducer.send(message).get();
            Assertions.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
        this.checkMetricsAreRecorded();
    }
}

