/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProviderFactory;
import io.confluent.kafka.schemaregistry.validator.integration.RecordSchemaValidatorIntegrationTestHarness;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;

public class ValidationAuthTest
extends RecordSchemaValidatorIntegrationTestHarness {
    Properties schemaRegistryProps = new Properties();

    public ValidationAuthTest() {
        super(3, true, CompatibilityLevel.NONE.name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        NewTopic testTopic = new NewTopic("test", 1, 1);
        testTopic.configs(Collections.singletonMap("confluent.value.schema.validation", "true"));
        this.createTopicThroughAdminClient(testTopic);
    }

    @Override
    protected KafkaProducer<Object, Object> createProducer(Class<?> keySerializer, Class<?> valueSerializer) {
        Properties props = this.getProducerProps();
        props.put("key.serializer", keySerializer);
        props.put("value.serializer", valueSerializer);
        props.put("basic.auth.credentials.source", "USER_INFO");
        props.put("basic.auth.user.info", "admin:password");
        return new KafkaProducer(props);
    }

    protected void setupBasicAuthClient(String user, String password) {
        String restUrl = new StringBuilder(this.restApp.restConnect).insert(this.getSchemaRegistryProtocol().length() + 3, user + ":" + password + "@").toString();
        this.restApp.restClient = new RestService(restUrl);
        BasicAuthCredentialProvider basicAuthCredentialProvider = BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider((String)"URL", new HashMap());
        this.restApp.restClient.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
    }

    protected Properties getSchemaRegistryProperties() {
        Configuration.setConfiguration(null);
        this.schemaRegistryProps.put("authentication.method", "BASIC");
        this.schemaRegistryProps.put("authentication.realm", "SchemaRegistry");
        this.schemaRegistryProps.put("authentication.roles", "admin");
        try {
            File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
            jaasConfigFile.deleteOnExit();
            File userPropsFile = new File(ValidationAuthTest.class.getResource("/testauth.properties").getFile());
            System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            lines.add((CallSite)((Object)("SchemaRegistry { org.eclipse.jetty.security.jaas.spi.PropertyFileLoginModule required file=\"" + userPropsFile.getAbsolutePath() + "\";};")));
            Files.write(jaasConfigFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.schemaRegistryProps;
    }
}

